/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.utils.security.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class FileEncryptor {
    private final Path file;
    private final String token;

    public FileEncryptor(File tar, String key) {
        this.file = tar.toPath();
        this.token = key;
    }

    public FileEncryptor(Path tar, String key) {
        this.file = tar;
        this.token = key;
    }

    public boolean encrypt() {
        try {
            Path tmp = this.file.getParent().resolve(this.file.getFileName().toString() + ".tmp");
            SecretKeySpec secret = new SecretKeySpec(this.token.getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secret);
            FileInputStream inputStream = new FileInputStream(this.file.toFile());
            byte[] inputBytes = new byte[(int)this.file.toFile().length()];
            byte[] outputBytes = cipher.doFinal(inputBytes);
            FileOutputStream outputStream = new FileOutputStream(tmp.toFile());
            outputStream.write(outputBytes);
            inputStream.close();
            outputStream.close();
            Files.move(tmp, this.file, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean decrypt() {
        try {
            Path tmp = this.file.getParent().resolve(this.file.getFileName().toString() + ".tmp");
            SecretKeySpec secret = new SecretKeySpec(this.token.getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secret);
            FileInputStream inputStream = new FileInputStream(this.file.toFile());
            byte[] inputBytes = new byte[(int)this.file.toFile().length()];
            byte[] outputBytes = cipher.doFinal(inputBytes);
            FileOutputStream outputStream = new FileOutputStream(tmp.toFile());
            outputStream.write(outputBytes);
            inputStream.close();
            outputStream.close();
            Files.move(tmp, this.file, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

