/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.utils.string;

import java.util.Random;
import ml.karmaconfigs.api.common.utils.string.OptionsBuilder;

public final class RandomString {
    private final OptionsBuilder options;

    RandomString() {
        this.options = new OptionsBuilder();
    }

    RandomString(OptionsBuilder opts) {
        this.options = opts;
    }

    public String create() {
        char[] salt;
        switch (this.options.getContent()) {
            case ONLY_NUMBERS: {
                salt = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
                break;
            }
            case NUMBERS_AND_LETTERS: {
                salt = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
                break;
            }
            default: {
                salt = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'x', 'y', 'z'};
            }
        }
        StringBuilder result = new StringBuilder();
        int last_int = 0;
        for (int i = 0; i < this.options.getSize(); ++i) {
            int random = new Random().nextInt(salt.length);
            if (last_int != random) {
                String lower = String.valueOf(salt[random]);
                String upper = String.valueOf(salt[random]).toUpperCase();
                switch (this.options.getType()) {
                    case ALL_LOWER: {
                        result.append(lower);
                        break;
                    }
                    case ALL_UPPER: {
                        result.append(upper);
                        break;
                    }
                    default: {
                        int random_s = new Random().nextInt(100);
                        if (random_s > 50) {
                            result.append(lower);
                            break;
                        }
                        result.append(upper);
                    }
                }
                last_int = random;
                continue;
            }
            --i;
        }
        return result.toString();
    }

    public static OptionsBuilder createBuilder() {
        return new OptionsBuilder();
    }
}

