/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.version;

import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.version.util.VersionResolver;
import ml.karmaconfigs.api.common.version.util.VersionType;

public class VersionFetchResult {
    private final boolean updated;
    private final String latest;
    private final String current;
    private final String update;
    private final String[] changelog;
    private final VersionResolver resolver;

    public VersionFetchResult(KarmaSource source, String latest_version, String downloadURL, String[] changes, VersionResolver solver) {
        this.updated = true;
        this.latest = latest_version;
        this.current = source.version();
        this.update = downloadURL;
        this.changelog = changes;
        this.resolver = solver;
    }

    VersionFetchResult(boolean status, String fetched, String active, String url, String[] changes, VersionResolver solver) {
        this.updated = status;
        this.latest = fetched;
        this.current = active;
        this.update = url;
        this.changelog = changes;
        this.resolver = solver;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public String getLatest() {
        return this.latest;
    }

    public String getCurrent() {
        return this.current;
    }

    public String getUpdateURL() {
        return this.update;
    }

    public String resolve(VersionType type) {
        if (this.resolver != null) {
            switch (type) {
                case LATEST: {
                    return this.resolver.resolve(this.latest);
                }
                case CURRENT: {
                    return this.resolver.resolve(this.current);
                }
            }
        } else {
            switch (type) {
                case CURRENT: {
                    return this.current;
                }
                case LATEST: {
                    return this.latest;
                }
            }
        }
        return this.latest;
    }

    public String[] getChangelog() {
        return this.changelog;
    }
}

