/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.karma;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import ml.karmaconfigs.api.common.karma.APISource;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.karma.loader.BruteLoader;
import ml.karmaconfigs.api.common.karma.loader.component.NameComponent;
import ml.karmaconfigs.api.common.utils.URLUtils;
import ml.karmaconfigs.api.common.utils.enums.Level;
import ml.karmaconfigs.api.common.utils.string.StringUtils;

public interface KarmaAPI
extends Serializable {
    public static String getVersion() {
        String version = "-1";
        try {
            InputStream in = KarmaAPI.class.getResourceAsStream("/api.properties");
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                version = properties.getProperty("version", "-1");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    public static String getCompilerVersion() {
        String version = "16";
        try {
            InputStream in = KarmaAPI.class.getResourceAsStream("/api.properties");
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                version = properties.getProperty("java_version", "15");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    public static String getBuildDate() {
        String compile_date = "01-01-1999 00:00:00";
        try {
            InputStream in = KarmaAPI.class.getResourceAsStream("/api.properties");
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                compile_date = properties.getProperty("compile_date", "01-01-1999 00:00:00");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return compile_date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLoaded(KarmaSource source) {
        boolean status = false;
        Path destJar = null;
        try {
            Path sourceJar2332 = source.getSourceFile().toPath();
            destJar = Files.createTempFile(StringUtils.generateString().create() + "_", StringUtils.generateString().create(), new FileAttribute[0]);
            Files.move(sourceJar2332, destJar, new CopyOption[0]);
            Files.move(destJar, sourceJar2332, new CopyOption[0]);
        }
        catch (Throwable ex) {
            try {
                status = true;
                return status;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    Files.deleteIfExists(destJar);
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            Files.deleteIfExists(destJar);
            return status;
        }
        catch (Throwable sourceJar2332) {
            return status;
        }
    }

    public static KarmaSource source(boolean force) {
        return APISource.getOriginal(force);
    }

    public static void install() {
        BruteLoader loader = null;
        try {
            loader = new BruteLoader((URLClassLoader)KarmaAPI.source(false).getClass().getClassLoader());
        }
        catch (Throwable ex) {
            try {
                loader = new BruteLoader((URLClassLoader)Thread.currentThread().getContextClassLoader());
            }
            catch (Throwable exc) {
                KarmaAPI.source(false).console().send((CharSequence)"Failed to install KarmaAPI dependencies because of {0}", Level.GRAVE, ex.fillInStackTrace());
                for (StackTraceElement element : ex.getStackTrace()) {
                    KarmaAPI.source(false).console().send((CharSequence)"&c             {0}", element);
                }
            }
        }
        if (loader != null) {
            try {
                Class.forName("com.google.gson.Gson");
            }
            catch (Throwable ex) {
                KarmaAPI.source(false).console().send((CharSequence)"Google GSON dependency not found for UUID utilities, downloading it...", Level.WARNING);
                loader.downloadAndInject(URLUtils.getOrNull("https://repo1.maven.org/maven2/com/google/code/gson/gson/2.8.9/gson-2.8.9.jar"), NameComponent.forFile("GoogleGSON", "jar", new String[0]));
            }
            try {
                Class.forName("org.apache.http.HttpResponse");
            }
            catch (Throwable ex) {
                KarmaAPI.source(false).console().send((CharSequence)"Apache HTTP components not found for URL utilities, downloading it...", Level.WARNING);
                loader.downloadAndInject(URLUtils.getOrNull("https://repo1.maven.org/maven2/org/apache/httpcomponents/httpclient/4.5.13/httpclient-4.5.13.jar"), NameComponent.forFile("ApacheHTTP", "jar", new String[0]));
            }
        }
    }
}

