/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.karma.loader;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import ml.karmaconfigs.api.common.JavaVM;
import ml.karmaconfigs.api.common.ResourceDownloader;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.karma.loader.component.NameComponent;
import org.burningwave.core.assembler.StaticComponentContainer;

public final class BruteLoader {
    private static boolean open = false;
    private final URLClassLoader loader;

    public BruteLoader(URLClassLoader ucl) {
        this.loader = ucl;
        if (JavaVM.javaVersion() > 11 && !open) {
            open = true;
            StaticComponentContainer.Modules.exportAllToAll();
            StaticComponentContainer.ManagedLoggerRepository.close();
        }
    }

    public void downloadAndInject(URL downloadURL, NameComponent name) {
        name.addParentStart("dependencies");
        ResourceDownloader downloader = ResourceDownloader.toCache(KarmaAPI.source(true), name.getName() + "." + name.findExtension(), downloadURL.toString(), name.getParents());
        downloader.download();
        this.add(downloader.getDestFile());
    }

    public boolean add(URL source) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)this.loader, source);
            method.setAccessible(false);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean add(File source) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)this.loader, source.toURI().toURL());
            method.setAccessible(false);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean add(Path source) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)this.loader, source.toUri().toURL());
            method.setAccessible(false);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public URLClassLoader getLoader() {
        return this.loader;
    }
}

