/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.karmafile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.karmafile.Key;
import ml.karmaconfigs.api.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.api.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.api.common.utils.file.FileUtilities;
import ml.karmaconfigs.api.common.utils.file.PathUtilities;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class AsyncKarmaFile
implements Serializable {
    private final File file;

    public AsyncKarmaFile(KarmaSource source, String name, String ... dir) throws IllegalStateException {
        Path dataFolder = source.getDataPath();
        if (dir.length > 0) {
            for (String str : dir) {
                dataFolder = dataFolder.resolve(str);
            }
        }
        this.file = PathUtilities.getFixedPath(dataFolder.resolve(name)).toFile();
        if (!FileUtilities.isValidFile(this.file)) {
            throw new IllegalStateException("Tried to start a karma file on invalid file path ( " + dataFolder.resolve(name) + " )");
        }
    }

    public AsyncKarmaFile(File target) {
        this.file = FileUtilities.getFixedFile(target);
    }

    public AsyncKarmaFile(Path target) {
        this.file = PathUtilities.getFixedPath(target).toFile();
    }

    public LateScheduler<Void> exportFromFile(InputStream resource) {
        AsyncLateScheduler<Void> result = new AsyncLateScheduler<Void>();
        KarmaAPI.source(true).async().queue(() -> {
            if (!this.exists()) {
                this.create().whenComplete(() -> this.exportFromFile(resource).whenComplete((rs, err) -> {
                    if (err != null) {
                        result.complete((Void)rs, null);
                    } else {
                        result.complete((Void)rs);
                    }
                }));
            } else {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));
                    BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                    while ((line = reader.readLine()) != null) {
                        writer.write(line + "\n");
                    }
                    writer.flush();
                    writer.close();
                    reader.close();
                    resource.close();
                    result.complete(null);
                }
                catch (Throwable ex) {
                    result.complete(null, ex);
                }
            }
        });
        return result;
    }

    private boolean isComment(String line) {
        if (line.startsWith("/*")) {
            return true;
        }
        return line.startsWith("/// ") || line.startsWith("// ") && line.endsWith(" -->");
    }

    private boolean isOpenList(String line, String path) {
        return line.equals("[LIST=" + path.replaceAll("\\s", "_") + "]");
    }

    private boolean isOpenList(String line) {
        return line.startsWith("[LIST=") && line.endsWith("]");
    }

    private boolean isCloseList(String line, String path) {
        return line.equals("[/LIST=" + path.replaceAll("\\s", "_") + "]");
    }

    private boolean isCloseList(String line) {
        return line.startsWith("[/LIST=") && line.endsWith("]");
    }

    private String getKeyPath(String line) {
        if (this.isOpenList(line) || this.isCloseList(line)) {
            String pathN1 = line.replaceFirst("\\[LIST=", "").replaceFirst("\\[/LIST=", "");
            return pathN1.substring(0, pathN1.length() - 1);
        }
        if (line.contains(":")) {
            return line.split(":")[0];
        }
        return line;
    }

    public LateScheduler<Void> applyKarmaAttribute() {
        AsyncLateScheduler<Void> result = new AsyncLateScheduler<Void>();
        KarmaAPI.source(true).async().queue(() -> {
            if (this.exists()) {
                try {
                    UserDefinedFileAttributeView view = Files.getFileAttributeView(this.file.toPath(), UserDefinedFileAttributeView.class, new LinkOption[0]);
                    view.write("filetp", Charset.defaultCharset().encode("KarmaFile"));
                    result.complete(null);
                }
                catch (Throwable ex) {
                    result.complete(null, ex);
                }
            } else {
                result.complete(null);
            }
        });
        return result;
    }

    public LateScheduler<Void> create() {
        AsyncLateScheduler<Void> result = new AsyncLateScheduler<Void>();
        KarmaAPI.source(true).async().queue(() -> {
            FileUtilities.create(this.file);
            result.complete(null);
        });
        return result;
    }

    public LateScheduler<Void> set(Object value) {
        AsyncLateScheduler<Void> result = new AsyncLateScheduler<Void>();
        KarmaAPI.source(true).async().queue(() -> {
            if (!this.exists()) {
                this.create().whenComplete(() -> this.set(value).whenComplete((rs, err) -> {
                    if (err != null) {
                        result.complete((Void)rs, (Throwable)err);
                    } else {
                        result.complete((Void)rs);
                    }
                }));
            } else {
                byte[] toByte = value.toString().getBytes(StandardCharsets.UTF_8);
                String val = new String(toByte, StandardCharsets.UTF_8);
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    ArrayList<String> sets = new ArrayList<String>();
                    boolean alreadySet = false;
                    while ((line = reader.readLine()) != null) {
                        if (!line.equals(value.toString())) {
                            sets.add(line);
                            continue;
                        }
                        alreadySet = true;
                        sets.add(val);
                    }
                    if (!alreadySet) {
                        sets.add(val);
                    }
                    BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                    for (Object e : sets) {
                        writer.write(e + "\n");
                    }
                    writer.flush();
                    writer.close();
                    result.complete(null);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(null, ex);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            }
        });
        return result;
    }

    public LateScheduler<Void> set(String path, Object value) {
        AsyncLateScheduler<Void> result = new AsyncLateScheduler<Void>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            if (!this.exists()) {
                this.create().whenComplete(() -> this.set(finalPath, value).whenComplete((rs, err) -> {
                    if (err != null) {
                        result.complete((Void)rs, (Throwable)err);
                    } else {
                        result.complete((Void)rs);
                    }
                }));
            } else {
                this.isSet(finalPath).whenComplete(rs -> {
                    if (rs.booleanValue()) {
                        this.unset(finalPath).whenComplete(() -> this.set(finalPath, value)).whenComplete((rs2, ex) -> {
                            if (ex != null) {
                                result.complete((Void)rs2, (Throwable)ex);
                            } else {
                                result.complete((Void)rs2);
                            }
                        });
                    } else {
                        byte[] toByte = value.toString().getBytes(StandardCharsets.UTF_8);
                        String val = new String(toByte, StandardCharsets.UTF_8);
                        BufferedReader reader = null;
                        try {
                            String line;
                            reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                            ArrayList<String> sets = new ArrayList<String>();
                            boolean alreadySet = false;
                            while ((line = reader.readLine()) != null) {
                                if (line.split(":")[0] == null) continue;
                                String currentPath = line.split(":")[0];
                                if (!currentPath.equals(finalPath)) {
                                    sets.add(line);
                                    continue;
                                }
                                alreadySet = true;
                                sets.add(finalPath + ": " + val);
                            }
                            if (!alreadySet) {
                                sets.add(finalPath + ": " + val);
                            }
                            BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                            for (Object e : sets) {
                                writer.write(e + "\n");
                            }
                            writer.flush();
                            writer.close();
                            result.complete(null);
                            this.closeStreams(reader);
                        }
                        catch (Throwable ex2) {
                            try {
                                result.complete(null, ex2);
                                this.closeStreams(reader);
                            }
                            catch (Throwable throwable) {
                                this.closeStreams(reader);
                                throw throwable;
                            }
                        }
                    }
                });
            }
        });
        return result;
    }

    public LateScheduler<Void> set(String path, List<?> list) {
        AsyncLateScheduler<Void> result = new AsyncLateScheduler<Void>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            if (!this.exists()) {
                this.create();
            }
            this.isSet(finalPath).whenComplete(rs -> {
                if (rs.booleanValue()) {
                    this.unset(finalPath).whenComplete(() -> this.set(finalPath, list)).whenComplete((rs2, ex) -> {
                        if (ex != null) {
                            result.complete((Void)rs2, (Throwable)ex);
                        } else {
                            result.complete((Void)rs2);
                        }
                    });
                } else {
                    BufferedReader reader = null;
                    try {
                        String line;
                        reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                        ArrayList<String> sets = new ArrayList<String>();
                        boolean adding = true;
                        while ((line = reader.readLine()) != null) {
                            if (line.equals("[LIST=" + finalPath + "]")) {
                                adding = false;
                            }
                            if (!adding && line.equals("[/LIST=" + finalPath + "]")) {
                                adding = true;
                            }
                            if (!adding || line.equals("[LIST=" + finalPath + "]") || line.equals("[/LIST=" + finalPath + "]")) continue;
                            sets.add(line);
                        }
                        sets.add("[LIST=" + finalPath + "]");
                        for (Object val : list) {
                            sets.add(val.toString());
                        }
                        sets.add("[/LIST=" + finalPath + "]");
                        BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                        for (String str : sets) {
                            writer.write(str + "\n");
                        }
                        writer.flush();
                        writer.close();
                        result.complete(null);
                        this.closeStreams(reader);
                    }
                    catch (Throwable ex2) {
                        try {
                            result.complete(null, ex2);
                            this.closeStreams(reader);
                        }
                        catch (Throwable throwable) {
                            this.closeStreams(reader);
                            throw throwable;
                        }
                    }
                }
            });
        });
        return result;
    }

    public LateScheduler<Void> unset(String path) {
        AsyncLateScheduler<Void> result = new AsyncLateScheduler<Void>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            if (!this.exists()) {
                this.create();
            }
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                while ((line = reader.readLine()) != null) {
                    if (line.equals(finalPath)) continue;
                    writer.write(line + "\n");
                }
                writer.flush();
                writer.close();
                result.complete(null);
                this.closeStreams(reader);
            }
            catch (Throwable ex) {
                try {
                    result.complete(null, ex);
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        });
        return result;
    }

    public LateScheduler<Void> unsetList(String path) {
        AsyncLateScheduler<Void> result = new AsyncLateScheduler<Void>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            if (!this.exists()) {
                this.create().whenComplete(() -> this.unsetList(finalPath).whenComplete((rs, err) -> {
                    if (err != null) {
                        result.complete(null, (Throwable)err);
                    } else {
                        result.complete(null);
                    }
                }));
            } else {
                BufferedReader reader = null;
                boolean list = false;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                    while ((line = reader.readLine()) != null) {
                        if (this.isOpenList(line) && this.getKeyPath(line).equals(finalPath)) {
                            list = true;
                        } else if (this.isCloseList(line) && this.getKeyPath(line).equals(finalPath)) {
                            list = false;
                        }
                        if (list) continue;
                        writer.write(line + "\n");
                    }
                    writer.flush();
                    writer.close();
                    result.complete(null);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(null, ex);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            }
        });
        return result;
    }

    public void delete() {
        FileUtilities.destroy(this.file);
    }

    @NotNull
    public LateScheduler<Object> get(String path, @NotNull Object def) {
        AsyncLateScheduler<Object> result = new AsyncLateScheduler<Object>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            Object val = def;
            if (this.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        String actualPath;
                        if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(finalPath)) continue;
                        val = line.replace(actualPath + ": ", "");
                    }
                    result.complete(val);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(val, ex);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            } else {
                result.complete(val);
            }
        });
        return result;
    }

    @NotNull
    public LateScheduler<String> getString(String path, @NotNull String def) {
        AsyncLateScheduler<String> result = new AsyncLateScheduler<String>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            String val = def;
            if (this.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        String actualPath;
                        if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(finalPath)) continue;
                        val = line.replace(actualPath + ": ", "");
                    }
                    result.complete(val);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(val, ex);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            } else {
                result.complete(val);
            }
        });
        return result;
    }

    @NotNull
    public LateScheduler<List<?>> getList(String path, Object ... default_contents) {
        AsyncLateScheduler result = new AsyncLateScheduler();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            ArrayList values = new ArrayList();
            this.isSet(finalPath).whenComplete(rs -> {
                if (rs.booleanValue() && this.exists()) {
                    BufferedReader reader = null;
                    try {
                        String line;
                        reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                        boolean adding = false;
                        while ((line = reader.readLine()) != null) {
                            if (this.isOpenList(line.toString(), finalPath)) {
                                adding = true;
                            }
                            if (this.isCloseList(line.toString(), finalPath)) {
                                adding = false;
                            }
                            if (!adding || this.isOpenList(line.toString(), finalPath) || line.toString().startsWith("/// ") || line.toString().endsWith(" -->")) continue;
                            values.add(line);
                        }
                        result.complete(values);
                        this.closeStreams(reader);
                    }
                    catch (Throwable ex) {
                        try {
                            result.complete(values, ex);
                            this.closeStreams(reader);
                        }
                        catch (Throwable throwable) {
                            this.closeStreams(reader);
                            throw throwable;
                        }
                    }
                } else {
                    values.addAll(Arrays.asList(default_contents));
                    result.complete(values);
                }
            });
        });
        return result;
    }

    @NotNull
    public LateScheduler<List<String>> getStringList(String path, String ... default_contents) {
        AsyncLateScheduler<List<String>> result = new AsyncLateScheduler<List<String>>();
        Object[] default_objects = Arrays.copyOf((Object[])default_contents, default_contents.length);
        path = path.replaceAll("\\s", "_");
        this.getList(path, default_objects).whenComplete((unknownList, error) -> {
            ArrayList<String> values = new ArrayList<String>();
            if (!unknownList.isEmpty()) {
                for (Object value : unknownList) {
                    String str = value.toString();
                    if (str.startsWith("/// ") || str.endsWith(" -->")) continue;
                    values.add(str);
                }
            }
            result.complete(values);
        });
        return result;
    }

    @NotNull
    public LateScheduler<List<String>> readFullFile() {
        AsyncLateScheduler<List<String>> result = new AsyncLateScheduler<List<String>>();
        KarmaAPI.source(true).async().queue(() -> {
            try {
                result.complete(Files.readAllLines(this.file.toPath()));
            }
            catch (Throwable ex) {
                result.complete(Collections.emptyList(), ex);
            }
        });
        return result;
    }

    public LateScheduler<Boolean> getBoolean(String path, boolean def) {
        AsyncLateScheduler<Boolean> result = new AsyncLateScheduler<Boolean>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            boolean val = def;
            if (this.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        String actualPath;
                        if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(finalPath)) continue;
                        val = Boolean.parseBoolean(line.replace(actualPath + ": ", ""));
                    }
                    result.complete(val);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(val, ex);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            } else {
                result.complete(val);
            }
        });
        return result;
    }

    public LateScheduler<Boolean> isList(String path) {
        AsyncLateScheduler<Boolean> result = new AsyncLateScheduler<Boolean>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> this.isSet(finalPath).whenComplete(rs -> {
            boolean exist = false;
            if (rs.booleanValue() && this.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    boolean adding = false;
                    while ((line = reader.readLine()) != null) {
                        if (!this.isOpenList(line.toString(), finalPath)) continue;
                        exist = true;
                    }
                    result.complete(exist);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(exist, null);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            } else {
                result.complete(false);
            }
        }));
        return result;
    }

    public LateScheduler<Boolean> isSet(String path) {
        AsyncLateScheduler<Boolean> result = new AsyncLateScheduler<Boolean>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            boolean set = false;
            if (this.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        String currentPath;
                        if (line.split(":")[0] == null || !(currentPath = line.split(":")[0]).equals(finalPath) && !this.isOpenList(line, finalPath) && !this.isCloseList(line, finalPath)) continue;
                        set = true;
                        break;
                    }
                    result.complete(set);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(set, ex);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            } else {
                result.complete(false);
            }
        });
        return result;
    }

    public LateScheduler<Integer> getInt(String path, int def) {
        AsyncLateScheduler<Integer> result = new AsyncLateScheduler<Integer>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            int val = def;
            if (this.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        String actualPath;
                        if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(finalPath)) continue;
                        val = Integer.parseInt(line.replace(actualPath + ": ", ""));
                    }
                    result.complete(val);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(val, ex);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            } else {
                result.complete(val);
            }
        });
        return result;
    }

    public LateScheduler<Double> getDouble(String path, double def) {
        AsyncLateScheduler<Double> result = new AsyncLateScheduler<Double>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            double val = def;
            if (this.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        String actualPath;
                        if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(finalPath)) continue;
                        val = Double.parseDouble(line.replace(actualPath + ": ", ""));
                    }
                    result.complete(val);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(val, ex);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            } else {
                result.complete(val);
            }
        });
        return result;
    }

    public LateScheduler<Long> getLong(String path, long def) {
        AsyncLateScheduler<Long> result = new AsyncLateScheduler<Long>();
        String finalPath = path = path.replaceAll("\\s", "_");
        KarmaAPI.source(true).async().queue(() -> {
            long val = def;
            if (this.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        String actualPath;
                        if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(finalPath)) continue;
                        val = Long.parseLong(line.replace(actualPath + ": ", ""));
                    }
                    result.complete(val);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(val, ex);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            } else {
                result.complete(val);
            }
        });
        return result;
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public LateScheduler<Set<Key>> getKeys(boolean deep) {
        AsyncLateScheduler<Set<Key>> result = new AsyncLateScheduler<Set<Key>>();
        LinkedHashSet keys = new LinkedHashSet();
        KarmaAPI.source(true).async().queue(() -> {
            if (this.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        if (line.replaceAll("\\s", "").isEmpty() || this.isComment(line)) continue;
                        AtomicReference key = new AtomicReference();
                        String pathKey = this.getKeyPath(line);
                        this.isList(pathKey).whenComplete(rs -> {
                            if (rs.booleanValue()) {
                                this.getList(pathKey, new Object[0]).whenComplete(unknownList -> {
                                    if (unknownList.isEmpty()) {
                                        if (deep) {
                                            key.set(new Key(pathKey, unknownList));
                                        }
                                    } else {
                                        key.set(new Key(pathKey, unknownList));
                                    }
                                });
                                keys.add((Key)key.get());
                            } else {
                                LateScheduler<Object> value = this.get(pathKey, "");
                                if (StringUtils.isNullOrEmpty(value)) {
                                    if (deep) {
                                        key.set(new Key(pathKey, value));
                                    }
                                } else {
                                    key.set(new Key(pathKey, value));
                                }
                            }
                            keys.add((Key)key.get());
                        });
                    }
                    result.complete(keys);
                    this.closeStreams(reader);
                }
                catch (Throwable ex) {
                    try {
                        result.complete(keys, ex);
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            } else {
                result.complete(keys);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String val = "";
        if (this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                StringBuilder val_builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    val_builder.append(line);
                }
                val = val_builder.toString();
                this.closeStreams(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return val;
    }

    private void closeStreams(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

