/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.utils;

import java.nio.file.Path;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.utils.enums.Level;
import ml.karmaconfigs.api.common.utils.enums.LogCalendar;
import ml.karmaconfigs.api.common.utils.enums.LogExtension;
import ml.karmaconfigs.api.common.utils.file.PathUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class KarmaLogger
implements AutoCloseable {
    private static final Map<String, KarmaLogger> loggers = new ConcurrentHashMap<String, KarmaLogger>();
    private final KarmaSource source;
    private final boolean flush;
    private final boolean printErrors;
    private final boolean printMessages;

    public KarmaLogger(KarmaSource owner) {
        KarmaLogger stored = loggers.getOrDefault(owner.name().toLowerCase(), null);
        if (stored == null) {
            this.source = owner;
            this.flush = true;
            this.printErrors = false;
            this.printMessages = false;
            loggers.put(owner.name().toLowerCase(), this);
        } else {
            this.source = stored.source;
            this.flush = stored.flush;
            this.printErrors = stored.printErrors;
            this.printMessages = stored.printMessages;
        }
    }

    public KarmaLogger(KarmaSource owner, boolean autoFlush, boolean errors, boolean messages) {
        KarmaLogger stored = loggers.getOrDefault(owner.name().toLowerCase(), null);
        if (stored == null) {
            this.source = owner;
            this.flush = autoFlush;
            this.printErrors = errors;
            this.printMessages = messages;
            loggers.put(owner.name().toLowerCase(), this);
        } else {
            this.source = stored.source;
            this.flush = stored.flush;
            this.printErrors = stored.printErrors;
            this.printMessages = stored.printMessages;
        }
    }

    public abstract void scheduleLog(Level var1, CharSequence var2, Object ... var3);

    public abstract void scheduleLog(Level var1, Throwable var2);

    public abstract void scheduleLogOption(Level var1, boolean var2, CharSequence var3, Object ... var4);

    public abstract void scheduleLogOption(Level var1, boolean var2, Throwable var3);

    public abstract void syncedLog(Level var1, CharSequence var2, Object ... var3);

    public abstract void syncedLog(Level var1, Throwable var2);

    public abstract void syncedLogOption(Level var1, boolean var2, CharSequence var3, Object ... var4);

    public abstract void syncedLogOption(Level var1, boolean var2, Throwable var3);

    public abstract void clearLog();

    @ApiStatus.Experimental
    public abstract boolean flush();

    @Override
    public final void close() {
        loggers.remove(this.source.name().toLowerCase());
    }

    protected Path getLoggerFile(LogExtension type) {
        Calendar calendar = Calendar.getInstance();
        String year = String.valueOf(calendar.get(1));
        String month = calendar.getDisplayName(2, 2, Locale.getDefault());
        String day = String.valueOf(calendar.get(5));
        Path log = this.source.getDataPath().resolve("logs").resolve(year).resolve(month).resolve(day + "." + type.fileExtension());
        PathUtilities.create(log);
        return log;
    }

    protected String fetchTime(LogCalendar type) {
        Calendar calendar = type.getType();
        return String.format("%02d", calendar.get(11)) + ":" + String.format("%02d", calendar.get(12)) + ":" + String.format("%02d", calendar.get(13));
    }

    protected final boolean printInfo() {
        return this.printMessages;
    }

    protected final boolean printError() {
        return this.printErrors;
    }

    @Nullable
    public static KarmaLogger getLogger(String name) {
        return loggers.getOrDefault(name, loggers.get("karmaapi"));
    }
}

