/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.utils.security.data;

import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBECryptoAPI {
    private final String password;
    private final byte[] content;

    public PBECryptoAPI(String pwd, byte[] ctn) {
        this.password = pwd;
        this.content = ctn;
    }

    public final byte[] generateSALT() {
        SecureRandom r = new SecureRandom();
        byte[] newSeed = r.generateSeed(8);
        r.setSeed(newSeed);
        byte[] saltValue = new byte[8];
        r.nextBytes(saltValue);
        return saltValue;
    }

    public final byte[] encrypt(byte[] salt) throws Exception {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 20);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(this.password.toCharArray());
        SecretKey key = keyFactory.generateSecret(pbeKeySpec);
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(1, (Key)key, pbeParamSpec);
        return pbeCipher.doFinal(this.content);
    }

    public final byte[] decrypt(byte[] salt) throws Exception {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 20);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(this.password.toCharArray());
        SecretKey key = keyFactory.generateSecret(pbeKeySpec);
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(2, (Key)key, pbeParamSpec);
        return pbeCipher.doFinal(this.content);
    }
}

