/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.version.spigot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URL;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.api.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.api.common.utils.URLUtils;
import ml.karmaconfigs.api.common.utils.string.StringUtils;

public final class SpigotChecker {
    private final int resource_id;
    private static final String fetch_version = "https://api.spigotmc.org/simple/0.2/index.php?action=getResource&id={0}";
    private static final String fetch_update = "https://api.spigotmc.org/simple/0.2/index.php?action=getResourceUpdates&id={0}&page={1}";
    private static final String update_url = "https://www.spigotmc.org/resources/{0}/update?update={1}";

    public SpigotChecker(int id) {
        this.resource_id = id;
    }

    public String getLatest() {
        try {
            Gson gson;
            JsonObject object;
            URL url = new URL(StringUtils.formatString((CharSequence)fetch_version, this.resource_id));
            String response = URLUtils.getResponse(url);
            if (response != null && (object = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson(response, JsonObject.class)).has("current_version")) {
                return object.get("current_version").getAsString();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public LateScheduler<URL> getUpdateURL() {
        AsyncLateScheduler<URL> result = new AsyncLateScheduler<URL>();
        KarmaAPI.source(false).async().queue(() -> {
            try {
                int page = 0;
                URL url = new URL(StringUtils.formatString((CharSequence)fetch_update, this.resource_id, page));
                String response = URLUtils.getResponse(url);
                if (response != null) {
                    while (!response.equalsIgnoreCase("[]")) {
                        url = new URL(StringUtils.formatString((CharSequence)fetch_update, this.resource_id, ++page));
                        response = URLUtils.getResponse(url);
                    }
                }
                url = new URL(StringUtils.formatString((CharSequence)fetch_update, this.resource_id, --page));
                response = URLUtils.getResponse(url);
                Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                JsonArray array = (JsonArray)gson.fromJson(response, JsonArray.class);
                JsonElement last = array.get(array.size() - 1);
                if (last.isJsonObject()) {
                    JsonObject object = last.getAsJsonObject();
                    if (object.has("id")) {
                        int updateId = object.get("id").getAsInt();
                        URL updateInfo = new URL(StringUtils.formatString((CharSequence)update_url, this.resource_id, updateId));
                        result.complete(updateInfo);
                    } else {
                        result.complete(null);
                    }
                } else {
                    result.complete(null);
                }
            }
            catch (Throwable ex) {
                result.complete(null, ex);
            }
        });
        return result;
    }
}

