/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.velocity;

import com.velocitypowered.api.proxy.Player;
import java.util.function.BiConsumer;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.utils.placeholder.GlobalPlaceholderEngine;
import ml.karmaconfigs.api.common.utils.placeholder.util.Placeholder;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import org.jetbrains.annotations.Nullable;

public class VelocityPlaceholder {
    public static Placeholder<String> createTextPlaceholder(final String key, final BiConsumer<Player, String> onRequest) {
        return new Placeholder<String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue(@Nullable Object container) {
                if (container instanceof Player) {
                    Player player = (Player)container;
                    String original = "placeholder " + key + " value";
                    onRequest.accept(player, original);
                    return original;
                }
                return StringUtils.toColor("&ccontainer not a player");
            }

            @Override
            public Class<?> getType() {
                return Player.class;
            }
        };
    }

    public static Placeholder<Integer> createIntegerPlaceholder(final String key, final BiConsumer<Player, Integer> onRequest) {
        return new Placeholder<Integer>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Integer getValue(@Nullable Object container) {
                if (container instanceof Player) {
                    Player player = (Player)container;
                    int original = Integer.MAX_VALUE;
                    onRequest.accept(player, original);
                    return original;
                }
                return Integer.MIN_VALUE;
            }

            @Override
            public Class<?> getType() {
                return Player.class;
            }
        };
    }

    public static Placeholder<Double> createDoublePlaceholder(final String key, final BiConsumer<Player, Double> onRequest) {
        return new Placeholder<Double>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Double getValue(@Nullable Object container) {
                if (container instanceof Player) {
                    Player player = (Player)container;
                    double original = Double.MAX_VALUE;
                    onRequest.accept(player, original);
                    return original;
                }
                return Double.MIN_VALUE;
            }

            @Override
            public Class<?> getType() {
                return Player.class;
            }
        };
    }

    public static Placeholder<Float> createFloatPlaceholder(final String key, final BiConsumer<Player, Float> onRequest) {
        return new Placeholder<Float>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Float getValue(@Nullable Object container) {
                if (container instanceof Player) {
                    Player player = (Player)container;
                    float original = Float.MAX_VALUE;
                    onRequest.accept(player, Float.valueOf(original));
                    return Float.valueOf(original);
                }
                return Float.valueOf(Float.MIN_VALUE);
            }

            @Override
            public Class<?> getType() {
                return Player.class;
            }
        };
    }

    public static <T> Placeholder<T> createAnyPlaceholder(final String key, final BiConsumer<Player, T> onRequest) {
        return new Placeholder<T>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public T getValue(@Nullable Object container) {
                if (container instanceof Player) {
                    Player player = (Player)container;
                    Object original = null;
                    onRequest.accept(player, original);
                    return original;
                }
                return null;
            }

            @Override
            public Class<?> getType() {
                return Player.class;
            }
        };
    }

    public static void registerPlayerPlaceholder(Placeholder<?> ... placeholders) {
        GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
        engine.protect();
        engine.registerUnsafe(placeholders);
    }
}

