/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.velocity.makeiteasy;

import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.api.common.boss.BossColor;
import ml.karmaconfigs.api.common.boss.BossNotFoundException;
import ml.karmaconfigs.api.common.boss.BossProvider;
import ml.karmaconfigs.api.common.boss.BossType;
import ml.karmaconfigs.api.common.boss.ProgressiveBar;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.timer.SourceSecondsTimer;
import ml.karmaconfigs.api.common.timer.scheduler.SimpleScheduler;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;

public final class BossMessage
extends BossProvider<Player> {
    private final KarmaSource plugin;
    private String message;
    private final double live_time;
    private static int bars = 0;
    private static final List<BossMessage> b_bars = new ArrayList<BossMessage>();
    private static final Map<Integer, BossMessage> boss_bars = new LinkedHashMap<Integer, BossMessage>();
    private static final Map<Integer, BossBar> bar_objects = new LinkedHashMap<Integer, BossBar>();
    private final Set<UUID> shown = Collections.newSetFromMap(new ConcurrentHashMap());
    private BossColor color = BossColor.PURPLE;
    private BossType type = BossType.SOLID;
    private ProgressiveBar progress = ProgressiveBar.NONE;
    private double lived_time = 0.0;
    private boolean cancelled = false;
    private static int total_ids = 0;
    private final int id;
    private SimpleScheduler bar_timer = null;

    public BossMessage(KarmaSource owner, String _message, double duration) {
        this.plugin = owner;
        this.message = _message;
        this.live_time = duration;
        this.id = ++total_ids;
    }

    @Override
    public BossProvider<Player> color(BossColor newColor) {
        this.color = newColor;
        return this;
    }

    @Override
    public BossProvider<Player> style(BossType newType) {
        this.type = newType;
        return this;
    }

    @Override
    public BossProvider<Player> progress(ProgressiveBar type) {
        this.progress = type;
        return this;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    protected void displayBar(Collection<Player> players) {
        ArrayList<Player> fixed = new ArrayList<Player>();
        for (Player player : players) {
            if (player == null || this.shown.contains(player.getUniqueId())) continue;
            fixed.add(player);
            this.shown.add(player.getUniqueId());
        }
        ++bars;
        if (this.cancelled) {
            this.cancelled = false;
        }
        switch (this.progress) {
            case DOWN: {
                this.lived_time = this.live_time - 1.0;
                break;
            }
            case UP: {
                this.lived_time = 0.0;
            }
        }
        BossBar bar = BossBar.bossBar((ComponentLike)Component.text().content(StringUtils.toColor(this.message)), (float)1.0f, (BossBar.Color)BossBar.Color.valueOf((String)this.color.name()), (BossBar.Overlay)BossBar.Overlay.valueOf((String)this.type.name().replace("SEGMENTED", "NOTCHED").replace("SOLID", "PROGRESS")));
        for (Player player : fixed) {
            player.showBossBar(bar);
        }
        bar_objects.put(this.id, bar);
        this.bar_timer = new SourceSecondsTimer(this.plugin, this.live_time, false).cancelUnloaded(false);
        this.bar_timer.endAction(() -> {
            for (Player player : fixed) {
                player.hideBossBar(bar);
                this.shown.remove(player.getUniqueId());
            }
            boss_bars.remove(this.id);
            bar_objects.remove(this.id);
            --bars;
        }).cancelAction(time -> {
            for (Player player : fixed) {
                player.hideBossBar(bar);
                this.shown.remove(player.getUniqueId());
            }
            boss_bars.remove(this.id);
            bar_objects.remove(this.id);
            --bars;
        }).start();
        SimpleScheduler simpleScheduler = new SourceSecondsTimer(this.plugin, this.live_time - 1.0, false).cancelUnloaded(false);
        simpleScheduler.secondChangeAction(second -> {
            if (!this.cancelled) {
                try {
                    bar.color(BossBar.Color.valueOf((String)this.color.name()));
                    bar.overlay(BossBar.Overlay.valueOf((String)this.type.name().replace("SEGMENTED", "NOTCHED").replace("SOLID", "PROGRESS")));
                    switch (this.progress) {
                        case UP: {
                            double life_value = this.lived_time / this.live_time;
                            if (life_value <= 1.0 && life_value >= 0.0) {
                                bar.progress((float)life_value);
                                this.lived_time += 1.0;
                                break;
                            }
                            this.cancel();
                            break;
                        }
                        case DOWN: {
                            double life_value = (double)second.intValue() / this.live_time;
                            if (life_value <= 1.0 && life_value >= 0.0) {
                                bar.progress((float)life_value);
                                this.lived_time -= 1.0;
                                break;
                            }
                            this.cancel();
                        }
                    }
                }
                catch (Throwable ex) {
                    this.cancel();
                }
            } else {
                this.bar_timer.cancel();
                hp_timer.cancel();
            }
        }).start();
    }

    @Override
    public void scheduleBar(Collection<Player> players) {
        b_bars.add(this);
        boss_bars.put(this.id, this);
        SimpleScheduler timer = new SourceSecondsTimer(this.plugin, 1, false).cancelUnloaded(false).multiThreading(true);
        timer.periodChangeAction(milli -> {
            if (!b_bars.isEmpty() && this.getBarsAmount() < 4) {
                BossMessage boss = b_bars.get(0);
                boss.displayBar(players);
                b_bars.remove(boss);
            }
        }).start();
    }

    @Override
    public void scheduleBar(Player player) {
        b_bars.add(this);
        boss_bars.put(this.id, this);
        SimpleScheduler timer = new SourceSecondsTimer(this.plugin, 1, false).cancelUnloaded(false).multiThreading(true);
        timer.periodChangeAction(milli -> {
            if (!b_bars.isEmpty() && this.getBarsAmount() < 4) {
                BossMessage boss = b_bars.get(0);
                boss.displayBar((Collection<Player>)Collections.singleton(player));
                b_bars.remove(boss);
            }
        }).start();
    }

    @Override
    public int getBarsAmount() {
        return bars;
    }

    @Override
    public int getBarId() {
        return this.id;
    }

    @Override
    public boolean update(String _message, boolean restart) {
        try {
            this.message = _message;
            BossBar bar = bar_objects.get(this.id);
            bar.name((Component)Component.text().content(StringUtils.toColor(this.message)).build());
            if (this.bar_timer != null && restart) {
                this.bar_timer.restart();
            }
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public BossProvider<Player> displayTime(double displayTime) {
        this.cancel();
        return new BossMessage(this.plugin, this.message, displayTime).color(this.color).style(this.type).progress(this.progress);
    }

    @Override
    public boolean isValid() {
        return bar_objects.containsKey(this.id);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public String getTitle() {
        return this.message;
    }

    @Override
    public BossColor getColor() {
        return this.color;
    }

    @Override
    public BossType getStyle() {
        return this.type;
    }

    public static interface getters {
        public static BossProvider<Player> getByID(int id) throws BossNotFoundException {
            try {
                BossMessage boss;
                if (boss_bars.containsKey(id) && (boss = (BossMessage)boss_bars.getOrDefault(id, null)) != null) {
                    return boss;
                }
                throw new BossNotFoundException(id, boss_bars.keySet());
            }
            catch (Throwable ex) {
                throw new BossNotFoundException(id, boss_bars.keySet());
            }
        }
    }
}

