/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.listener.ClientEvent;
import ml.karmaconfigs.remote.messaging.listener.RemoteListener;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerConnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerDisconnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerMessageEvent;
import ml.karmaconfigs.remote.messaging.remote.RemoteServer;

public final class Client {
    private static final byte[] BUFFER = new byte[1024];
    private static final String client_name = "client_" + new Random().nextInt(Integer.MAX_VALUE);
    private static final Set<DatagramPacket> packet_queue = Collections.newSetFromMap(new ConcurrentHashMap());
    private static String server = "127.0.0.1";
    private static int sv_port = 49305;
    private static int client = 49300;
    private static boolean debug = false;
    private static boolean operative = false;
    private static boolean award_connection = false;
    private static boolean instant_close = false;
    private static DatagramSocket socket;

    public Client() {
    }

    public Client(String server_host, int server_port) {
        server = server_host;
        sv_port = server_port;
    }

    public Client(int client_port, String server_host, int server_port) {
        client = client_port;
        server = server_host;
        sv_port = server_port;
    }

    public Client debug(boolean status) {
        debug = status;
        return this;
    }

    public CompletableFuture<Void> connect() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            try {
                String information;
                String command;
                String[] data;
                String text2;
                RemoteServer remote;
                int port;
                InetAddress incoming;
                DatagramPacket packet;
                DatagramPacket connect_packet;
                socket = new DatagramSocket(client);
                if (debug) {
                    System.out.println("Client........................ Initialized RM client");
                }
                if ((connect_packet = this.createPacket("{COMMAND:RM_CONNECT:" + client_name + "}")) != null) {
                    socket.send(connect_packet);
                    award_connection = true;
                }
                result.complete(null);
                block14: while (award_connection) {
                    packet = new DatagramPacket(BUFFER, BUFFER.length);
                    socket.receive(packet);
                    incoming = packet.getAddress();
                    port = packet.getPort();
                    remote = new RemoteServer(incoming, port, socket);
                    if (!incoming.getHostAddress().equals(server) || port != sv_port) continue;
                    try {
                        text2 = new String(packet.getData(), 0, packet.getLength(), StandardCharsets.UTF_8);
                        if (!text2.startsWith("{COMMAND:") || !text2.endsWith("}")) continue;
                        text2 = text2.replaceFirst("\\{COMMAND:", "");
                        if (!(text2 = text2.substring(0, text2.length() - 1)).contains(":")) continue;
                        data = text2.split(":");
                        command = data[0];
                        information = text2.replaceFirst(command + ":", "");
                        switch (command.toLowerCase()) {
                            case "rm_disconnect": {
                                if (!debug) continue block14;
                                System.out.println("Client........................ Connection killed by server: " + information);
                                ClientEvent event = new ServerDisconnectEvent(remote, information);
                                RemoteListener.callClientEvent(event);
                                break;
                            }
                            case "rm_accept": {
                                if (debug) {
                                    System.out.println("Client........................ Connection accepted by server: " + information);
                                }
                                ClientEvent event = new ServerConnectEvent(remote);
                                RemoteListener.callClientEvent(event);
                                operative = true;
                                award_connection = false;
                                for (DatagramPacket queue : packet_queue) {
                                    socket.send(queue);
                                }
                                packet_queue.clear();
                                if (!instant_close) continue block14;
                                this.close();
                                break;
                            }
                            default: {
                                if (!debug) continue block14;
                                System.out.println("Client........................ Unknown command from " + server + ":" + port + " -> " + command + ": " + information);
                            }
                        }
                    }
                    catch (Throwable text2) {}
                }
                while (operative) {
                    packet = new DatagramPacket(BUFFER, BUFFER.length);
                    socket.receive(packet);
                    incoming = packet.getAddress();
                    port = packet.getPort();
                    remote = new RemoteServer(incoming, port, socket);
                    if (!incoming.getHostAddress().equals(server) || port != sv_port) continue;
                    try {
                        text2 = new String(packet.getData(), 0, packet.getLength(), StandardCharsets.UTF_8);
                        if (text2.startsWith("{COMMAND:") && text2.endsWith("}")) {
                            text2 = text2.replaceFirst("\\{COMMAND:", "");
                            if (!(text2 = text2.substring(0, text2.length() - 1)).contains(":")) continue;
                            data = text2.split(":");
                            command = data[0];
                            information = text2.replaceFirst(command + ":", "");
                            if (!command.equalsIgnoreCase("rm_disconnect")) continue;
                            if (debug) {
                                System.out.println("Client........................ Connection killed by server: " + information);
                            }
                            socket.close();
                            socket = null;
                            ServerDisconnectEvent event = new ServerDisconnectEvent(remote, information);
                            RemoteListener.callClientEvent(event);
                            operative = false;
                            continue;
                        }
                        ServerMessageEvent event = new ServerMessageEvent(remote, Arrays.copyOfRange(packet.getData(), 0, packet.getLength()));
                        RemoteListener.callClientEvent(event);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
        thread.start();
        return result;
    }

    public void rename(String name) {
        try {
            DatagramPacket assign_name_packet = this.createPacket("{COMMAND:RM_ASSIGN_NAME:" + name + "}");
            if (assign_name_packet != null) {
                socket.send(assign_name_packet);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void send(byte[] data) {
        if (award_connection) {
            try {
                DatagramPacket packet = new DatagramPacket(data, data.length, InetAddress.getByName(server), sv_port);
                packet_queue.add(packet);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else if (operative) {
            try {
                DatagramPacket packet = new DatagramPacket(data, data.length, InetAddress.getByName(server), sv_port);
                socket.send(packet);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public void close() {
        try {
            if (!award_connection) {
                DatagramPacket packet = this.createPacket("{COMMAND:RM_DISCONNECT:Connection killed by client}");
                socket.send(packet);
                socket.close();
                socket = null;
                operative = false;
            } else {
                instant_close = true;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private DatagramPacket createPacket(String data) {
        try {
            return new DatagramPacket(data.getBytes(StandardCharsets.UTF_8), data.length(), InetAddress.getByName(server), sv_port);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

