/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.listener.RemoteListener;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientCommandEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientConnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientDisconnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientMessageEvent;
import ml.karmaconfigs.remote.messaging.remote.RemoteClient;
import ml.karmaconfigs.remote.messaging.util.DisconnectReason;

public final class Server {
    private static int port = 49305;
    private static boolean debug = false;
    private static boolean operative = true;
    private static DatagramSocket socket;
    private static final byte[] BUFFER;
    private static final Set<String> connections;
    private static final Map<String, String> names;
    private static final Map<String, RemoteClient> clients;
    private static final Set<String> banned;

    public Server() {
    }

    public Server(int custom_port) {
        port = custom_port;
    }

    public Server debug(boolean status) {
        debug = status;
        return this;
    }

    public CompletableFuture<Void> start() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            try {
                socket = new DatagramSocket(port);
                if (debug) {
                    System.out.println("Server........................ Initialized RM server");
                }
                result.complete(null);
                while (operative) {
                    DatagramPacket packet = new DatagramPacket(BUFFER, BUFFER.length);
                    socket.receive(packet);
                    InetAddress incoming = packet.getAddress();
                    int port = packet.getPort();
                    RemoteClient client = this.getClient(incoming, port);
                    try {
                        String text = new String(packet.getData(), 0, packet.getLength(), StandardCharsets.UTF_8);
                        if (text.startsWith("{COMMAND:") && text.endsWith("}")) {
                            text = text.replaceFirst("\\{COMMAND:", "");
                            if (!(text = text.substring(0, text.length() - 1)).contains(":")) continue;
                            String[] data = text.split(":");
                            String command = data[0];
                            String information = text.replaceFirst(command + ":", "");
                            switch (command.toLowerCase()) {
                                case "rm_connect": {
                                    DatagramPacket response;
                                    String rText;
                                    ClientDisconnectEvent event;
                                    if (!banned.contains(incoming.getHostAddress())) {
                                        if (!connections.contains(incoming.getHostAddress() + "/" + port)) {
                                            if (debug) {
                                                System.out.println("Server........................ Connected new client from " + this.getName(incoming, port) + " -> " + command + ": " + information);
                                            }
                                            connections.add(incoming.getHostAddress() + "/" + port);
                                            names.put(incoming.getHostAddress() + "/" + port, information.replaceAll("\\s", "_").toLowerCase());
                                            String rText2 = "{COMMAND:RM_ACCEPT:Connection established successfully}";
                                            DatagramPacket response2 = new DatagramPacket(rText2.getBytes(StandardCharsets.UTF_8), rText2.getBytes(StandardCharsets.UTF_8).length, incoming, port);
                                            socket.send(response2);
                                            ClientConnectEvent event2 = new ClientConnectEvent(client);
                                            RemoteListener.callServerEvent(event2);
                                            break;
                                        }
                                        if (debug) {
                                            System.out.println("Server........................ Client " + this.getName(incoming, port) + " tried to access the server but he's already connected!");
                                        }
                                        event = new ClientDisconnectEvent(client, DisconnectReason.BANNED, "You are already connected to the server from another machine!");
                                        RemoteListener.callServerEvent(event);
                                        rText = "{COMMAND:RM_DISCONNECT:" + event.getDisconnectMessage() + "!}";
                                        response = new DatagramPacket(rText.getBytes(StandardCharsets.UTF_8), rText.getBytes(StandardCharsets.UTF_8).length, incoming, port);
                                        socket.send(response);
                                        break;
                                    }
                                    if (debug) {
                                        System.out.println("Server........................ Banned client " + this.getName(incoming, port) + " tried to access the server");
                                    }
                                    connections.remove(incoming.getHostAddress() + "/" + port);
                                    names.remove(incoming.getHostAddress() + "/" + port);
                                    clients.remove(incoming.getHostAddress() + "/" + port);
                                    event = new ClientDisconnectEvent(client, DisconnectReason.BANNED, "You are banned from this server!");
                                    RemoteListener.callServerEvent(event);
                                    rText = "{COMMAND:RM_DISCONNECT:" + event.getDisconnectMessage() + "!}";
                                    response = new DatagramPacket(rText.getBytes(StandardCharsets.UTF_8), rText.getBytes(StandardCharsets.UTF_8).length, incoming, port);
                                    socket.send(response);
                                    break;
                                }
                                case "rm_assign_name": {
                                    if (!connections.contains(incoming.getHostAddress() + "/" + port)) break;
                                    if (debug) {
                                        System.out.println("Server........................ Client changed name " + this.getName(incoming, port) + " -> " + information);
                                    }
                                    names.put(incoming.getHostAddress() + "/" + port, information.replaceAll("\\s", "_").toLowerCase());
                                    clients.put(incoming.getHostAddress() + "/" + port, new RemoteClient(information, incoming, port, socket));
                                    break;
                                }
                                case "rm_disconnect": {
                                    if (!connections.contains(incoming.getHostAddress() + "/" + port)) break;
                                    if (debug) {
                                        System.out.println("Server........................ Client " + this.getName(incoming, port) + " disconnected -> " + information);
                                    }
                                    connections.remove(incoming.getHostAddress() + "/" + port);
                                    names.remove(incoming.getHostAddress() + "/" + port);
                                    clients.remove(incoming.getHostAddress() + "/" + port);
                                    ClientDisconnectEvent event = new ClientDisconnectEvent(client, DisconnectReason.KILLED_BY_CLIENT, information);
                                    RemoteListener.callServerEvent(event);
                                    break;
                                }
                                default: {
                                    if (!connections.contains(incoming.getHostAddress() + "/" + port) || !debug) break;
                                    System.out.println("Server........................ Unknown command from " + this.getName(incoming, port) + " -> " + command + ": " + information);
                                }
                            }
                            if (!connections.contains(incoming.getHostAddress() + "/" + port)) continue;
                            ClientCommandEvent event = new ClientCommandEvent(client, command, information, Arrays.copyOfRange(packet.getData(), 0, packet.getLength()));
                            RemoteListener.callServerEvent(event);
                            continue;
                        }
                        if (connections.contains(incoming.getHostAddress() + "/" + port)) {
                            ClientMessageEvent event = new ClientMessageEvent(client, Arrays.copyOfRange(packet.getData(), 0, packet.getLength()));
                            RemoteListener.callServerEvent(event);
                            continue;
                        }
                        if (!debug) continue;
                        System.out.println("Refused message from " + incoming.getHostAddress() + "/" + port + " ( " + text + " ) -> PLEASE CONNECT BEFORE SENDING A MESSAGE");
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
        thread.start();
        return result;
    }

    public void close() {
        operative = false;
    }

    public void broadcast(byte[] data) {
        try {
            for (RemoteClient client : clients.values()) {
                client.sendMessage(data);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void redirect(String name, byte[] data) {
        try {
            for (RemoteClient client : clients.values()) {
                if (!client.getName().equals(name)) continue;
                client.sendMessage(data);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void ban(String ... address) {
        try {
            List<String> ban = Arrays.asList(address);
            for (RemoteClient client : clients.values()) {
                InetAddress ip = client.getHost();
                if (!ban.contains(ip.getHostAddress())) continue;
                int port = client.getPort();
                ClientDisconnectEvent event = new ClientDisconnectEvent(client, DisconnectReason.BANNED, "You are banned from this server!");
                RemoteListener.callServerEvent(event);
                String rText = "{COMMAND:RM_DISCONNECT:" + event.getDisconnectMessage() + "}";
                DatagramPacket response = new DatagramPacket(rText.getBytes(StandardCharsets.UTF_8), rText.getBytes(StandardCharsets.UTF_8).length, ip, port);
                socket.send(response);
                connections.remove(ip.getHostAddress() + "/" + port);
                names.remove(ip.getHostAddress() + "/" + port);
                clients.remove(ip.getHostAddress() + "/" + port);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void kick(String ... address) {
        try {
            List<String> ban = Arrays.asList(address);
            for (RemoteClient client : clients.values()) {
                InetAddress ip = client.getHost();
                if (!ban.contains(ip.getHostAddress())) continue;
                int port = client.getPort();
                ClientDisconnectEvent event = new ClientDisconnectEvent(client, DisconnectReason.BANNED, "You have been disconnected by server!");
                RemoteListener.callServerEvent(event);
                String rText = "{COMMAND:RM_DISCONNECT:" + event.getDisconnectMessage() + "}";
                DatagramPacket response = new DatagramPacket(rText.getBytes(StandardCharsets.UTF_8), rText.getBytes(StandardCharsets.UTF_8).length, ip, port);
                socket.send(response);
                connections.remove(ip.getHostAddress() + "/" + port);
                names.remove(ip.getHostAddress() + "/" + port);
                clients.remove(ip.getHostAddress() + "/" + port);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void unBan(String ... address) {
        Arrays.asList(address).forEach(banned::remove);
    }

    private String getName(InetAddress address, int port) {
        return names.getOrDefault(address.getHostAddress() + "/" + port, address.getHostAddress() + "/" + port);
    }

    private RemoteClient getClient(InetAddress address, int port) {
        RemoteClient client = clients.getOrDefault(address.getHostAddress() + "/" + port, null);
        if (client == null) {
            client = new RemoteClient(this.getName(address, port), address, port, socket);
            clients.put(address.getHostAddress() + "/" + port, client);
        }
        return client;
    }

    static {
        BUFFER = new byte[1024];
        connections = Collections.newSetFromMap(new ConcurrentHashMap());
        names = new ConcurrentHashMap<String, String>();
        clients = new ConcurrentHashMap<String, RemoteClient>();
        banned = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

