/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karma;

import ml.karmaconfigs.remote.messaging.karmaapi.common.Console;
import ml.karmaconfigs.remote.messaging.karmaapi.common.Logger;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.Scheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;

public final class APISource
implements KarmaSource {
    private static KarmaSource instance;
    private static Logger logger;
    private static boolean locked;

    APISource() {
        instance = this;
        logger = new Logger(instance);
    }

    public static void setProvider(KarmaSource source) {
        if (!locked) {
            instance = source;
            logger = new Logger(instance);
        } else {
            APISource.getConsole().send("&b[ KarmaAPI ] &cSource {0} tried to overwrite the current source provider", Level.GRAVE, source.name());
        }
        locked = true;
    }

    public static KarmaSource getSource() {
        if (instance == null) {
            return new APISource();
        }
        return instance;
    }

    public static Console getConsole() {
        return APISource.getSource().out();
    }

    public static Logger getLogger() {
        return logger;
    }

    public static Scheduler asyncScheduler() {
        return instance.async();
    }

    public static Scheduler syncScheduler() {
        return instance.async();
    }

    @Override
    public String name() {
        return "KarmaAPI";
    }

    @Override
    public String version() {
        return KarmaAPI.getVersion();
    }

    @Override
    public String description() {
        return "KarmaAPI is an API made specially for plugin developer but also with utilities for base java.";
    }

    @Override
    public String[] authors() {
        return new String[]{"KarmaDev"};
    }

    @Override
    public String updateURL() {
        return "";
    }

    static {
        locked = false;
    }
}

