/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.remote;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public final class RemoteClient {
    private final String name;
    private final InetAddress host;
    private final int port;
    private final DatagramSocket serverSocket;

    public RemoteClient(String client, InetAddress address, int incoming_port, DatagramSocket server) {
        this.name = client;
        this.host = address;
        this.port = incoming_port;
        this.serverSocket = server;
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean sendMessage(byte[] message) {
        try {
            DatagramPacket msg = this.createDataPacket(message);
            if (msg != null) {
                this.serverSocket.send(msg);
                return true;
            }
            return false;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private DatagramPacket createDataPacket(byte[] data) {
        try {
            return new DatagramPacket(data, data.length, this.host, this.port);
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

