/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.remote;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public final class RemoteServer {
    private final InetAddress host;
    private final int port;
    private final DatagramSocket clientSocket;

    public RemoteServer(InetAddress address, int incoming_port, DatagramSocket client) {
        this.host = address;
        this.port = incoming_port;
        this.clientSocket = client;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean sendMessage(byte[] message) {
        try {
            DatagramPacket msg = this.createDataPacket(message);
            if (msg != null) {
                this.clientSocket.send(msg);
                return true;
            }
            return false;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private DatagramPacket createDataPacket(byte[] data) {
        try {
            return new DatagramPacket(data, data.length, this.host, this.port);
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

