/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.google.common.collect;

import java.util.Queue;
import javax.annotation.CheckForNull;
import ml.karmaconfigs.remote.messaging.google.common.annotations.GwtCompatible;
import ml.karmaconfigs.remote.messaging.google.common.base.Preconditions;
import ml.karmaconfigs.remote.messaging.google.common.collect.AbstractIterator;
import ml.karmaconfigs.remote.messaging.google.common.collect.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    public T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

