/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.google.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import ml.karmaconfigs.remote.messaging.google.common.annotations.GwtCompatible;
import ml.karmaconfigs.remote.messaging.google.common.annotations.GwtIncompatible;
import ml.karmaconfigs.remote.messaging.google.common.annotations.VisibleForTesting;
import ml.karmaconfigs.remote.messaging.google.common.base.Preconditions;
import ml.karmaconfigs.remote.messaging.google.common.collect.ElementTypesAreNonnullByDefault;
import ml.karmaconfigs.remote.messaging.google.common.collect.HashMultimapGwtSerializationDependencies;
import ml.karmaconfigs.remote.messaging.google.common.collect.Multimap;
import ml.karmaconfigs.remote.messaging.google.common.collect.Platform;
import ml.karmaconfigs.remote.messaging.google.common.collect.Serialization;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class HashMultimap<K, V>
extends HashMultimapGwtSerializationDependencies<K, V> {
    private static final int DEFAULT_VALUES_PER_KEY = 2;
    @VisibleForTesting
    transient int expectedValuesPerKey = 2;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <K, V> HashMultimap<K, V> create() {
        return new HashMultimap<K, V>();
    }

    public static <K, V> HashMultimap<K, V> create(int expectedKeys, int expectedValuesPerKey) {
        return new HashMultimap<K, V>(expectedKeys, expectedValuesPerKey);
    }

    public static <K, V> HashMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new HashMultimap<K, V>(multimap);
    }

    private HashMultimap() {
        this(12, 2);
    }

    private HashMultimap(int expectedKeys, int expectedValuesPerKey) {
        super(Platform.newHashMapWithExpectedSize(expectedKeys));
        Preconditions.checkArgument(expectedValuesPerKey >= 0);
        this.expectedValuesPerKey = expectedValuesPerKey;
    }

    private HashMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(Platform.newHashMapWithExpectedSize(multimap.keySet().size()));
        this.putAll(multimap);
    }

    @Override
    Set<V> createCollection() {
        return Platform.newHashSetWithExpectedSize(this.expectedValuesPerKey);
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultimap(this, stream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.expectedValuesPerKey = 2;
        int distinctKeys = Serialization.readCount(stream);
        Map map = Platform.newHashMapWithExpectedSize(12);
        this.setMap(map);
        Serialization.populateMultimap(this, stream, distinctKeys);
    }
}

