/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.google.common.collect;

import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.CheckForNull;
import ml.karmaconfigs.remote.messaging.google.common.annotations.Beta;
import ml.karmaconfigs.remote.messaging.google.common.annotations.GwtIncompatible;
import ml.karmaconfigs.remote.messaging.google.common.collect.ElementTypesAreNonnullByDefault;
import ml.karmaconfigs.remote.messaging.google.common.collect.Range;
import ml.karmaconfigs.remote.messaging.google.errorprone.annotations.DoNotMock;
import org.checkerframework.checker.nullness.qual.Nullable;

@DoNotMock(value="Use ImmutableRangeMap or TreeRangeMap")
@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public interface RangeMap<K extends Comparable, V> {
    @CheckForNull
    public V get(K var1);

    @CheckForNull
    public Map.Entry<Range<K>, V> getEntry(K var1);

    public Range<K> span();

    public void put(Range<K> var1, V var2);

    public void putCoalescing(Range<K> var1, V var2);

    public void putAll(RangeMap<K, V> var1);

    public void clear();

    public void remove(Range<K> var1);

    public void merge(Range<K> var1, @CheckForNull V var2, BiFunction<? super V, ? super @Nullable V, ? extends @Nullable V> var3);

    public Map<Range<K>, V> asMapOfRanges();

    public Map<Range<K>, V> asDescendingMapOfRanges();

    public RangeMap<K, V> subRangeMap(Range<K> var1);

    public boolean equals(@CheckForNull Object var1);

    public int hashCode();

    public String toString();
}

