/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.google.common.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import ml.karmaconfigs.remote.messaging.google.common.annotations.Beta;
import ml.karmaconfigs.remote.messaging.google.common.annotations.GwtIncompatible;
import ml.karmaconfigs.remote.messaging.google.common.base.Preconditions;
import ml.karmaconfigs.remote.messaging.google.common.io.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

