/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.APISource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.Key;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class KarmaFile
implements Serializable {
    private static boolean broadcast_file_creation = false;
    private static boolean broadcast_folder_creation = false;
    private final File file;

    public KarmaFile(KarmaSource source, String name, String ... dir) {
        File dataFolder = source.getDataPath().toFile();
        if (dir.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (String str : dir) {
                builder.append(File.separator).append(str);
            }
            this.file = new File(dataFolder + builder.toString(), name);
        } else {
            this.file = new File(dataFolder, name);
        }
    }

    public KarmaFile(File target) {
        this.file = FileUtilities.getFixedFile(target);
    }

    public void setBroadcastOptions(boolean broadcast_folder, boolean broadcast_file) {
        broadcast_file_creation = broadcast_file;
        broadcast_folder_creation = broadcast_folder;
    }

    public void exportFromFile(InputStream resource) {
        if (!this.exists()) {
            this.create();
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));
            BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            while ((line = reader.readLine()) != null) {
                writer.write(line + "\n");
            }
            writer.flush();
            writer.close();
            reader.close();
            resource.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private boolean isComment(String line) {
        if (line.startsWith("/*")) {
            return true;
        }
        return line.startsWith("/// ") || line.startsWith("// ") && line.endsWith(" -->");
    }

    private boolean isOpenList(String line, String path) {
        return line.equals("[LIST=" + path.replaceAll("\\s", "_") + "]");
    }

    private boolean isOpenList(String line) {
        return line.startsWith("[LIST=") && line.endsWith("]");
    }

    private boolean isCloseList(String line, String path) {
        return line.equals("[/LIST=" + path.replaceAll("\\s", "_") + "]");
    }

    private boolean isCloseList(String line) {
        return line.startsWith("[/LIST=") && line.endsWith("]");
    }

    private String getKeyPath(String line) {
        if (this.isOpenList(line) || this.isCloseList(line)) {
            String pathN1 = line.replaceFirst("\\[LIST=", "").replaceFirst("\\[/LIST=", "");
            return pathN1.substring(0, pathN1.length() - 1);
        }
        if (line.contains(":")) {
            return line.split(":")[0];
        }
        return line;
    }

    public void applyKarmaAttribute() {
        if (this.exists()) {
            try {
                UserDefinedFileAttributeView view = Files.getFileAttributeView(this.file.toPath(), UserDefinedFileAttributeView.class, new LinkOption[0]);
                view.write("filetp", Charset.defaultCharset().encode("KarmaFile"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void create() {
        String dir;
        if (!this.file.getParentFile().exists()) {
            dir = this.file.getParentFile().getPath().replaceAll("\\\\", "/");
            if (this.file.getParentFile().mkdirs()) {
                if (broadcast_folder_creation) {
                    APISource.getConsole().send("&aCreated directory {0}", dir);
                }
            } else {
                APISource.getConsole().send("&cAn unknown error occurred while creating directory {0}", dir);
            }
        }
        if (!this.file.exists()) {
            try {
                dir = this.file.getPath().replaceAll("\\\\", "/");
                if (this.file.createNewFile()) {
                    if (broadcast_file_creation) {
                        APISource.getConsole().send("&aCreated file {0}", dir);
                    }
                } else {
                    APISource.getConsole().send("&cAn unknown error occurred while creating file {0}", dir);
                }
                this.applyKarmaAttribute();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object value) {
        if (!this.exists()) {
            this.create();
        }
        byte[] toByte = value.toString().getBytes(StandardCharsets.UTF_8);
        String val = new String(toByte, StandardCharsets.UTF_8);
        BufferedReader reader = null;
        try {
            String line;
            reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
            ArrayList<String> sets = new ArrayList<String>();
            boolean alreadySet = false;
            while ((line = reader.readLine()) != null) {
                if (!line.equals(value.toString())) {
                    sets.add(line);
                    continue;
                }
                alreadySet = true;
                sets.add(val);
            }
            if (!alreadySet) {
                sets.add(val);
            }
            BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            for (Object e : sets) {
                writer.write(e + "\n");
            }
            writer.flush();
            writer.close();
            this.closeStreams(reader);
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                this.closeStreams(reader);
            }
            catch (Throwable throwable) {
                this.closeStreams(reader);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String path, Object value) {
        if (!this.exists()) {
            this.create();
        }
        if (this.isSet(path = path.replaceAll("\\s", "_")) && this.isList(path)) {
            this.unset(path);
        }
        byte[] toByte = value.toString().getBytes(StandardCharsets.UTF_8);
        String val = new String(toByte, StandardCharsets.UTF_8);
        BufferedReader reader = null;
        try {
            String line;
            reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
            ArrayList<String> sets = new ArrayList<String>();
            boolean alreadySet = false;
            while ((line = reader.readLine()) != null) {
                if (line.split(":")[0] == null) continue;
                String currentPath = line.split(":")[0];
                if (!currentPath.equals(path)) {
                    sets.add(line);
                    continue;
                }
                alreadySet = true;
                sets.add(path + ": " + val);
            }
            if (!alreadySet) {
                sets.add(path + ": " + val);
            }
            BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            for (Object e : sets) {
                writer.write(e + "\n");
            }
            writer.flush();
            writer.close();
            this.closeStreams(reader);
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                this.closeStreams(reader);
            }
            catch (Throwable throwable) {
                this.closeStreams(reader);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String path, List<?> list) {
        if (!this.exists()) {
            this.create();
        }
        if (this.isSet(path = path.replaceAll("\\s", "_")) && !this.isList(path)) {
            this.unset(path);
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
            ArrayList<String> sets = new ArrayList<String>();
            boolean adding = true;
            while ((line = reader.readLine()) != null) {
                if (line.equals("[LIST=" + path + "]")) {
                    adding = false;
                }
                if (!adding && line.equals("[/LIST=" + path + "]")) {
                    adding = true;
                }
                if (!adding || line.equals("[LIST=" + path + "]") || line.equals("[/LIST=" + path + "]")) continue;
                sets.add(line);
            }
            sets.add("[LIST=" + path + "]");
            for (Object val : list) {
                sets.add(val.toString());
            }
            sets.add("[/LIST=" + path + "]");
            BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            for (String str : sets) {
                writer.write(str + "\n");
            }
            writer.flush();
            writer.close();
            this.closeStreams(reader);
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                this.closeStreams(reader);
            }
            catch (Throwable throwable) {
                this.closeStreams(reader);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unset(String path) {
        if (!this.exists()) {
            this.create();
        }
        path = path.replaceAll("\\s", "_");
        BufferedReader reader = null;
        try {
            String line;
            reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
            BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            while ((line = reader.readLine()) != null) {
                if (line.equals(path)) continue;
                writer.write(line + "\n");
            }
            writer.flush();
            writer.close();
            this.closeStreams(reader);
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                this.closeStreams(reader);
            }
            catch (Throwable throwable) {
                this.closeStreams(reader);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetList(String path) {
        if (!this.exists()) {
            this.create();
        }
        path = path.replaceAll("\\s", "_");
        BufferedReader reader = null;
        boolean list = false;
        try {
            String line;
            reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
            BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            while ((line = reader.readLine()) != null) {
                if (this.isOpenList(line) && this.getKeyPath(line).equals(path)) {
                    list = true;
                } else if (this.isCloseList(line) && this.getKeyPath(line).equals(path)) {
                    list = false;
                }
                if (list) continue;
                writer.write(line + "\n");
            }
            writer.flush();
            writer.close();
            this.closeStreams(reader);
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                this.closeStreams(reader);
            }
            catch (Throwable throwable) {
                this.closeStreams(reader);
                throw throwable;
            }
        }
    }

    public void delete() {
        try {
            Files.deleteIfExists(FileUtilities.getFixedFile(this.file).toPath());
        }
        catch (Throwable ex) {
            APISource.getConsole().send("&cFile {0} not deleted", FileUtilities.getPrettyParentFile(this.file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object get(String path, @NotNull Object def) {
        Object val = def;
        path = path.replaceAll("\\s", "_");
        if (this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                while ((line = reader.readLine()) != null) {
                    String actualPath;
                    if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
                    val = line.replace(actualPath + ": ", "");
                }
                this.closeStreams(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getString(String path, @NotNull String def) {
        String val = def;
        path = path.replaceAll("\\s", "_");
        if (this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                while ((line = reader.readLine()) != null) {
                    String actualPath;
                    if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
                    val = line.replace(actualPath + ": ", "");
                }
                this.closeStreams(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<?> getList(String path, Object ... default_contents) {
        path = path.replaceAll("\\s", "_");
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.isSet(path)) {
            if (this.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                    boolean adding = false;
                    while ((line = reader.readLine()) != null) {
                        if (this.isOpenList(line.toString(), path)) {
                            adding = true;
                        }
                        if (this.isCloseList(line.toString(), path)) {
                            adding = false;
                        }
                        if (!adding || this.isOpenList(line.toString(), path) || line.toString().startsWith("/// ") || line.toString().endsWith(" -->")) continue;
                        values.add(line);
                    }
                    ArrayList<Object> arrayList = values;
                    this.closeStreams(reader);
                    return arrayList;
                }
                catch (Throwable ex) {
                    try {
                        ex.printStackTrace();
                        this.closeStreams(reader);
                    }
                    catch (Throwable throwable) {
                        this.closeStreams(reader);
                        throw throwable;
                    }
                }
            }
        } else {
            values.addAll(Arrays.asList(default_contents));
        }
        return values;
    }

    @NotNull
    public List<String> getStringList(String path, String ... default_contents) {
        Object[] default_objects;
        ArrayList<String> values = new ArrayList<String>();
        List<?> originalList = this.getList(path = path.replaceAll("\\s", "_"), default_objects = Arrays.copyOf((Object[])default_contents, default_contents.length));
        if (!originalList.isEmpty()) {
            for (Object value : originalList) {
                String str = value.toString();
                if (str.startsWith("/// ") || str.endsWith(" -->")) continue;
                values.add(str);
            }
        }
        return values;
    }

    @NotNull
    public List<String> readFullFile() {
        try {
            return Files.readAllLines(this.file.toPath());
        }
        catch (Throwable ex) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String path, boolean def) {
        boolean val = def;
        path = path.replaceAll("\\s", "_");
        if (this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                while ((line = reader.readLine()) != null) {
                    String actualPath;
                    if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
                    val = Boolean.parseBoolean(line.replace(actualPath + ": ", ""));
                }
                this.closeStreams(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isList(String path) {
        path = path.replaceAll("\\s", "_");
        boolean exist = false;
        if (this.isSet(path) && this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                boolean adding = false;
                while ((line = reader.readLine()) != null) {
                    if (!this.isOpenList(line.toString(), path)) continue;
                    exist = true;
                }
                this.closeStreams(reader);
            }
            catch (Throwable ex) {
                try {
                    ex.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSet(String path) {
        path = path.replaceAll("\\s", "_");
        boolean set = false;
        if (this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                while ((line = reader.readLine()) != null) {
                    String currentPath;
                    if (line.split(":")[0] == null || !(currentPath = line.split(":")[0]).equals(path) && !this.isOpenList(line, path) && !this.isCloseList(line, path)) continue;
                    set = true;
                    break;
                }
                this.closeStreams(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String path, int def) {
        int val = def;
        path = path.replaceAll("\\s", "_");
        if (this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                while ((line = reader.readLine()) != null) {
                    String actualPath;
                    if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
                    val = Integer.parseInt(line.replace(actualPath + ": ", ""));
                }
                this.closeStreams(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String path, double def) {
        double val = def;
        path = path.replaceAll("\\s", "_");
        if (this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                while ((line = reader.readLine()) != null) {
                    String actualPath;
                    if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
                    val = Double.parseDouble(line.replace(actualPath + ": ", ""));
                }
                this.closeStreams(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String path, long def) {
        long val = def;
        path = path.replaceAll("\\s", "_");
        if (this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                while ((line = reader.readLine()) != null) {
                    String actualPath;
                    if (line.split(":")[0] == null || !(actualPath = line.split(":")[0]).equals(path)) continue;
                    val = Long.parseLong(line.replace(actualPath + ": ", ""));
                }
                this.closeStreams(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return val;
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Key> getKeys(boolean deep) {
        LinkedHashSet<Key> keys = new LinkedHashSet<Key>();
        if (this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                while ((line = reader.readLine()) != null) {
                    Key key;
                    if (line.replaceAll("\\s", "").isEmpty() || this.isComment(line)) continue;
                    String pathKey = this.getKeyPath(line);
                    if (this.isList(pathKey)) {
                        List<?> list = this.getList(pathKey, new Object[0]);
                        if (list.isEmpty() && !deep) continue;
                        key = new Key(pathKey, list);
                    } else {
                        Object value = this.get(pathKey, "");
                        if (StringUtils.isNullOrEmpty(value) && !deep) continue;
                        key = new Key(pathKey, value);
                    }
                    keys.add(key);
                }
                this.closeStreams(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String val = "";
        if (this.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);
                StringBuilder val_builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    val_builder.append(line);
                }
                val = val_builder.toString();
                this.closeStreams(reader);
            }
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    this.closeStreams(reader);
                }
                catch (Throwable throwable) {
                    this.closeStreams(reader);
                    throw throwable;
                }
            }
        }
        return val;
    }

    private void closeStreams(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

