/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.version;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.APISource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.URLUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.ComparatorBuilder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.VersionComparator;
import ml.karmaconfigs.remote.messaging.karmaapi.common.version.VersionFetchResult;
import ml.karmaconfigs.remote.messaging.karmaapi.common.version.VersionUpdater;
import ml.karmaconfigs.remote.messaging.karmaapi.common.version.util.VersionCheckType;
import ml.karmaconfigs.remote.messaging.karmaapi.common.version.util.VersionResolver;

public final class LegacyVersionUpdater
extends VersionUpdater {
    private static final Map<KarmaSource, VersionFetchResult> results = new ConcurrentHashMap<KarmaSource, VersionFetchResult>();
    private KarmaSource source;
    private URL checkURL;
    private VersionCheckType versionType;
    private VersionResolver versionResolver;

    private LegacyVersionUpdater() {
    }

    public static VersionUpdater.VersionBuilder createNewBuilder(KarmaSource owner) {
        return new LegacyVersionBuilder(owner);
    }

    @Override
    public LateScheduler<VersionFetchResult> fetch(boolean force) {
        AsyncLateScheduler<VersionFetchResult> asyncLateScheduler = new AsyncLateScheduler<VersionFetchResult>();
        if (force || !results.containsKey(this.source) || results.getOrDefault(this.source, null) == null) {
            APISource.asyncScheduler().queue(() -> {
                try {
                    boolean updated;
                    URLConnection connection = this.checkURL.openConnection();
                    InputStream file = connection.getInputStream();
                    Path temp = Files.createTempFile("kfetcher_", StringUtils.generateString().create(), new FileAttribute[0]);
                    File tempFile = FileUtilities.getFixedFile(temp.toFile());
                    tempFile.deleteOnExit();
                    if (!tempFile.exists()) {
                        Files.createFile(temp, new FileAttribute[0]);
                    }
                    Files.copy(file, temp, StandardCopyOption.REPLACE_EXISTING);
                    List<String> lines = Files.readAllLines(tempFile.toPath());
                    String version = lines.get(0);
                    String update = lines.get(1);
                    ArrayList<String> changelog = new ArrayList<String>();
                    for (int i = 2; i < lines.size(); ++i) {
                        changelog.add(lines.get(i));
                    }
                    switch (this.versionType) {
                        case ID: {
                            updated = this.source.version().equals(version);
                            break;
                        }
                        case RESOLVABLE_ID: {
                            ComparatorBuilder builder = VersionComparator.createBuilder().currentVersion(this.versionResolver.resolve(this.source.version())).checkVersion(this.versionResolver.resolve(version));
                            VersionComparator comparator = StringUtils.compareTo(builder);
                            updated = comparator.isUpToDate();
                            break;
                        }
                        default: {
                            ComparatorBuilder builder = VersionComparator.createBuilder().currentVersion(this.source.version()).checkVersion(version);
                            VersionComparator comparator = StringUtils.compareTo(builder);
                            updated = comparator.isUpToDate();
                        }
                    }
                    VersionFetchResult result = new VersionFetchResult(updated, version, this.source.version(), update, changelog.toArray(new String[0]), this.versionResolver);
                    results.put(this.source, result);
                    asyncLateScheduler.complete(result);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    asyncLateScheduler.complete(null, ex);
                }
            });
        } else {
            asyncLateScheduler.complete(results.get(this.source));
        }
        return asyncLateScheduler;
    }

    @Override
    public LateScheduler<VersionFetchResult> get() {
        AsyncLateScheduler<VersionFetchResult> asyncLateScheduler = new AsyncLateScheduler<VersionFetchResult>();
        APISource.asyncScheduler().queue(() -> {
            VersionFetchResult result = results.getOrDefault(this.source, null);
            if (result == null) {
                this.fetch(true).whenComplete(asyncLateScheduler::complete);
            } else {
                asyncLateScheduler.complete(result);
            }
        });
        return asyncLateScheduler;
    }

    public static class LegacyVersionBuilder
    extends VersionUpdater.VersionBuilder {
        LegacyVersionBuilder(KarmaSource owner) {
            super(owner);
        }

        @Override
        public VersionUpdater build() throws IllegalStateException {
            if (!StringUtils.isNullOrEmpty(URLUtils.getOrNull(this.getSource().updateURL()))) {
                LegacyVersionUpdater analyzer = new LegacyVersionUpdater();
                analyzer.source = this.getSource();
                analyzer.checkURL = URLUtils.getOrNull(this.getSource().updateURL());
                analyzer.versionType = this.getType();
                if (this.getType().equals((Object)VersionCheckType.RESOLVABLE_ID) && this.getResolver() == null) {
                    throw new IllegalStateException("Cannot build a version updater with null version resolver and using RESOLVABLE_ID version type");
                }
                analyzer.versionResolver = this.getResolver();
                return analyzer;
            }
            throw new IllegalStateException("Cannot build a version updater with null/invalid version check URL");
        }
    }
}

