/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.worker.tcp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.Client;
import ml.karmaconfigs.remote.messaging.google.common.io.ByteArrayDataInput;
import ml.karmaconfigs.remote.messaging.google.common.io.ByteArrayDataOutput;
import ml.karmaconfigs.remote.messaging.google.common.io.ByteStreams;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.APISource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.remote.RemoteServer;
import ml.karmaconfigs.remote.messaging.util.WorkLevel;

public final class TCPClient
extends Client {
    private static final ByteBuffer BUFFER = ByteBuffer.allocate(2048);
    private static final Set<byte[]> data_queue = Collections.newSetFromMap(new ConcurrentHashMap());
    private static String client_name = "client_" + new Random().nextInt(Integer.MAX_VALUE);
    private static String server = "127.0.0.1";
    private static int sv_port = 49305;
    private static int client = 49300;
    private static boolean debug = false;
    private static boolean operative = false;
    private static boolean instant_close = false;
    private static boolean award_connection = false;
    private static boolean tryingConnect = true;
    private static SocketChannel socket;

    public TCPClient() {
    }

    public TCPClient(String server_host, int server_port) {
        server = server_host;
        sv_port = server_port;
    }

    public TCPClient(int client_port, String server_host, int server_port) {
        client = client_port;
        server = server_host;
        sv_port = server_port;
    }

    @Override
    public Client debug(boolean status) {
        debug = status;
        return this;
    }

    @Override
    public CompletableFuture<Boolean> connect() {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Thread thread = new Thread(() -> {
            try {
                ByteBuffer readBuffer;
                if (debug) {
                    APISource.getConsole().send("Initializing the connection with the server", Level.INFO);
                }
                socket = SocketChannel.open().bind(new InetSocketAddress(client));
                socket.configureBlocking(false);
                socket.connect(new InetSocketAddress(server, sv_port));
                while (!socket.finishConnect()) {
                    if (!tryingConnect) continue;
                    if (debug) {
                        APISource.getConsole().send("Trying to establish a connection with {0}/{1}", Level.INFO, server, sv_port);
                    }
                    tryingConnect = false;
                }
                award_connection = true;
                tryingConnect = true;
                if (debug) {
                    APISource.getConsole().send("The connection has been established, waiting for the server to validate the connection", Level.INFO, server, sv_port);
                }
                while (award_connection) {
                    ByteArrayDataInput input;
                    readBuffer = ByteBuffer.allocate(1024);
                    socket.read(readBuffer);
                    if (tryingConnect) {
                        BUFFER.clear();
                        ByteArrayDataOutput out = ByteStreams.newDataOutput();
                        out.writeUTF(this.getMAC());
                        out.writeBoolean(true);
                        out.writeUTF("connect");
                        out.writeUTF(client_name);
                        BUFFER.put(out.toByteArray());
                        BUFFER.flip();
                        socket.write(BUFFER);
                        tryingConnect = false;
                        continue;
                    }
                    if (operative || !(input = ByteStreams.newDataInput(readBuffer.array())).readBoolean() || !input.readUTF().equalsIgnoreCase("accept")) continue;
                    if (debug) {
                        APISource.getConsole().send("Connection has been validated by the server", Level.INFO);
                    }
                    for (byte[] data : data_queue) {
                        BUFFER.clear();
                        BUFFER.put(data);
                        BUFFER.flip();
                        socket.write(BUFFER);
                        data_queue.remove(data);
                    }
                    award_connection = false;
                    operative = true;
                    if (!instant_close) continue;
                    this.close();
                }
                result.complete(true);
                block37: while (operative) {
                    readBuffer = ByteBuffer.allocate(1024);
                    int read = socket.read(readBuffer);
                    if (read == 0) {
                        for (byte[] queue : data_queue) {
                            BUFFER.clear();
                            BUFFER.put(queue);
                            BUFFER.flip();
                            socket.write(BUFFER);
                            data_queue.remove(queue);
                        }
                        continue;
                    }
                    ByteArrayDataInput input = ByteStreams.newDataInput(readBuffer.array());
                    if (input.readBoolean()) {
                        String command = input.readUTF();
                        String argument = input.readUTF();
                        block5 : switch (command.toLowerCase()) {
                            case "success": {
                                switch (argument.toLowerCase()) {
                                    case "rename": {
                                        client_name = input.readUTF();
                                        if (!debug) continue block37;
                                        APISource.getConsole().send("Server accepted the new client name: {0}", Level.INFO, client_name);
                                        break;
                                    }
                                    case "message": {
                                        if (!debug) continue block37;
                                        APISource.getConsole().send("{0} to server: {1}", Level.INFO, input.readUTF(), input.readUTF());
                                        break;
                                    }
                                    case "unknown": {
                                        if (!debug) continue block37;
                                        APISource.getConsole().send("{0} ran custom command: {1} ( {2} )", Level.INFO, input.readUTF(), input.readUTF(), input.readUTF());
                                        break;
                                    }
                                    default: {
                                        if (!debug) continue block37;
                                        APISource.getConsole().send("Unknown command from server: {0} ( {1} )", Level.WARNING, command, argument);
                                        break;
                                    }
                                }
                                continue block37;
                            }
                            case "failed": {
                                switch (argument.toLowerCase()) {
                                    case "connect": {
                                        APISource.getConsole().send("Server declined connection as {0}, because: {1}", Level.GRAVE, input.readUTF(), input.readUTF());
                                        break block5;
                                    }
                                    case "rename": {
                                        APISource.getConsole().send("Failed to change client name to {0}: {1}", Level.GRAVE, input.readUTF(), input.readUTF());
                                        break block5;
                                    }
                                    case "disconnect": {
                                        APISource.getConsole().send("Failed while trying to disconnect the server ( you've been disconnected anyway ): {0}", Level.GRAVE, input.readUTF());
                                        break block5;
                                    }
                                    case "message": {
                                        APISource.getConsole().send("Failed while trying to send a message to server: {0}", Level.GRAVE, input.readUTF());
                                        break block5;
                                    }
                                    case "unknown": {
                                        APISource.getConsole().send("Failed while trying to execute custom command {0} with argument {1}: {2}", Level.GRAVE, input.readUTF(), input.readUTF(), input.readUTF());
                                        break block5;
                                    }
                                }
                                if (!debug) break;
                                APISource.getConsole().send("Unknown command from server: {0} ( {1} )", Level.WARNING, command, argument);
                            }
                        }
                        continue;
                    }
                    APISource.getConsole().send("New message from server", Level.INFO);
                }
            }
            catch (Throwable ex) {
                result.complete(false);
            }
        });
        thread.start();
        return result;
    }

    @Override
    public String getName() {
        return client_name;
    }

    @Override
    public String getMAC() {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] macArray = network.getHardwareAddress();
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < macArray.length; ++i) {
                str.append(String.format("%02X%s", macArray[i], i < macArray.length - 1 ? ":" : ""));
            }
            return str.toString();
        }
        catch (Throwable ex) {
            System.out.println("Failed to locate MAC address...");
            System.exit(1);
            return null;
        }
    }

    @Override
    public RemoteServer getServer() {
        return null;
    }

    @Override
    public WorkLevel getWorkLevel() {
        return WorkLevel.TCP;
    }

    @Override
    public void rename(String name) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(this.getMAC());
        out.writeBoolean(true);
        out.writeUTF("rename");
        out.writeUTF(name);
        try {
            if (debug) {
                APISource.getConsole().send("Trying to inform the server about the name change request to {0}", Level.INFO, name);
            }
            BUFFER.clear();
            BUFFER.put(out.toByteArray());
            BUFFER.flip();
            socket.write(BUFFER);
        }
        catch (Throwable ex) {
            data_queue.add(out.toByteArray());
        }
    }

    @Override
    public void send(byte[] data) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(this.getMAC());
        out.writeBoolean(false);
        out.writeInt(out.toByteArray().length + 4);
        out.write(data);
        try {
            BUFFER.clear();
            BUFFER.put(out.toByteArray());
            BUFFER.flip();
            socket.write(BUFFER);
        }
        catch (Throwable ex) {
            data_queue.add(out.toByteArray());
        }
    }

    @Override
    public void close() {
        if (operative) {
            try {
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeUTF(this.getMAC());
                out.writeBoolean(true);
                out.writeUTF("disconnect");
                out.writeUTF("Client disconnect request");
                data_queue.add(out.toByteArray());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else {
            instant_close = true;
        }
    }
}

