/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.google.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import ml.karmaconfigs.remote.messaging.google.common.annotations.GwtCompatible;
import ml.karmaconfigs.remote.messaging.google.common.annotations.GwtIncompatible;
import ml.karmaconfigs.remote.messaging.google.common.collect.AbstractMapBasedMultiset;
import ml.karmaconfigs.remote.messaging.google.common.collect.ElementTypesAreNonnullByDefault;
import ml.karmaconfigs.remote.messaging.google.common.collect.Iterables;
import ml.karmaconfigs.remote.messaging.google.common.collect.Maps;
import ml.karmaconfigs.remote.messaging.google.common.collect.Multisets;
import ml.karmaconfigs.remote.messaging.google.common.collect.Serialization;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class HashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E> HashMultiset<E> create() {
        return new HashMultiset<E>();
    }

    public static <E> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    private HashMultiset() {
        super(new HashMap());
    }

    private HashMultiset(int distinctElements) {
        super(Maps.newHashMapWithExpectedSize(distinctElements));
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, stream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int distinctElements = Serialization.readCount(stream);
        this.setBackingMap(Maps.newHashMap());
        Serialization.populateMultiset(this, stream, distinctElements);
    }
}

