/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.google.common.util.concurrent;

import java.util.concurrent.Executor;
import ml.karmaconfigs.remote.messaging.google.common.annotations.GwtCompatible;
import ml.karmaconfigs.remote.messaging.google.common.base.Preconditions;
import ml.karmaconfigs.remote.messaging.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import ml.karmaconfigs.remote.messaging.google.common.util.concurrent.ForwardingFuture;
import ml.karmaconfigs.remote.messaging.google.common.util.concurrent.ListenableFuture;
import ml.karmaconfigs.remote.messaging.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@CanIgnoreReturnValue
@GwtCompatible
public abstract class ForwardingListenableFuture<V>
extends ForwardingFuture<V>
implements ListenableFuture<V> {
    protected ForwardingListenableFuture() {
    }

    @Override
    protected abstract ListenableFuture<? extends V> delegate();

    @Override
    public void addListener(Runnable listener, Executor exec) {
        this.delegate().addListener(listener, exec);
    }

    public static abstract class SimpleForwardingListenableFuture<V>
    extends ForwardingListenableFuture<V> {
        private final ListenableFuture<V> delegate;

        protected SimpleForwardingListenableFuture(ListenableFuture<V> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected final ListenableFuture<V> delegate() {
            return this.delegate;
        }
    }
}

