/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.PrefixConsoleData;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class Console {
    private static final Map<KarmaSource, Consumer<String>> messageActions = new ConcurrentHashMap<KarmaSource, Consumer<String>>();
    private final KarmaSource source;

    public Console(KarmaSource src) {
        this.source = src;
    }

    public Console(KarmaSource src, Consumer<String> onMessage) {
        this.source = src;
        if (onMessage != null && messageActions.getOrDefault(src, null) == null) {
            this.send("&b[ KarmaAPI &b]&7 Using custom console message sender");
        }
        messageActions.put(src, onMessage);
    }

    public PrefixConsoleData getData() {
        return new PrefixConsoleData(this.source);
    }

    public void send(String message) {
        Consumer messageAction = messageActions.getOrDefault(this.source, null);
        if (messageAction == null) {
            System.out.println("\u001b[0m" + StringUtils.toConsoleColor(message) + "\u001b[0m");
        } else {
            messageAction.accept(message);
        }
    }

    public void send(String message, Object ... replaces) {
        Consumer messageAction = messageActions.getOrDefault(this.source, null);
        String tmpMessage = message;
        for (int i = 0; i < replaces.length; ++i) {
            String placeholder = "{" + i + "}";
            String value = replaces[i].toString();
            tmpMessage = tmpMessage.replace(placeholder, value);
        }
        if (messageAction == null) {
            System.out.println("\u001b[0m" + StringUtils.toConsoleColor(tmpMessage) + "\u001b[0m");
        } else {
            messageAction.accept(tmpMessage);
        }
    }

    public void send(@NotNull String message, @NotNull Level level) {
        Consumer messageAction = messageActions.getOrDefault(this.source, null);
        String tmpMessage = message;
        String prefix = "&b[ &fALERT &b] &7NONE: &b";
        PrefixConsoleData data = this.getData();
        switch (level) {
            case OK: {
                prefix = data.getOkPrefix();
                break;
            }
            case INFO: {
                prefix = data.getInfoPrefix();
                break;
            }
            case WARNING: {
                prefix = data.getWarningPrefix();
                break;
            }
            case GRAVE: {
                prefix = data.getGravePrefix();
            }
        }
        tmpMessage = StringUtils.stripColor(tmpMessage);
        if (messageAction == null) {
            if (tmpMessage.contains("\n")) {
                for (String msg : tmpMessage.split("\n")) {
                    this.send(msg);
                }
            } else {
                this.send(prefix + tmpMessage);
            }
        } else {
            if (tmpMessage.contains("\n")) {
                tmpMessage = StringUtils.listToString(Arrays.asList(tmpMessage.split("\n")), false);
            }
            messageAction.accept(prefix + tmpMessage);
        }
    }

    public void send(@NotNull String message, @NotNull Level level, Object ... replaces) {
        Consumer messageAction = messageActions.getOrDefault(this.source, null);
        String tmpMessage = message;
        String prefix = "&b[ &fALERT &b] &7NONE: &b";
        PrefixConsoleData data = this.getData();
        switch (level) {
            case OK: {
                prefix = data.getOkPrefix();
                break;
            }
            case INFO: {
                prefix = data.getInfoPrefix();
                break;
            }
            case WARNING: {
                prefix = data.getWarningPrefix();
                break;
            }
            case GRAVE: {
                prefix = data.getGravePrefix();
            }
        }
        for (int i = 0; i < replaces.length; ++i) {
            String placeholder = "{" + i + "}";
            String value = replaces[i].toString();
            tmpMessage = tmpMessage.replace(placeholder, value);
        }
        tmpMessage = StringUtils.stripColor(tmpMessage);
        if (messageAction == null) {
            if (tmpMessage.contains("\n")) {
                for (String msg : tmpMessage.split("\n")) {
                    this.send(msg);
                }
            } else {
                this.send(prefix + tmpMessage);
            }
        } else {
            if (tmpMessage.contains("\n")) {
                tmpMessage = StringUtils.listToString(Arrays.asList(tmpMessage.split("\n")), false);
            }
            messageAction.accept(prefix + tmpMessage);
        }
    }
}

