/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karma;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;

public interface KarmaAPI
extends Serializable {
    public static String getVersion() {
        String version = "-1";
        try {
            InputStream in = KarmaAPI.class.getResourceAsStream("/api.properties");
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                version = properties.getProperty("version", "-1");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    public static String getCompilerVersion() {
        String version = "16";
        try {
            InputStream in = KarmaAPI.class.getResourceAsStream("/api.properties");
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                version = properties.getProperty("java_version", "15");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    public static String getBuildDate() {
        String compile_date = "01-01-1999 00:00:00";
        try {
            InputStream in = KarmaAPI.class.getResourceAsStream("/api.properties");
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                compile_date = properties.getProperty("compile_date", "01-01-1999 00:00:00");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return compile_date;
    }

    public static boolean isLoaded(KarmaSource source) {
        try {
            File jarFile = FileUtilities.getSourceFile(source);
            Path randomLocation = Files.createTempFile(StringUtils.generateString().create(), StringUtils.generateString().create(), new FileAttribute[0]);
            Files.copy(jarFile.toPath(), randomLocation, StandardCopyOption.REPLACE_EXISTING);
            Files.move(randomLocation, jarFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Files.deleteIfExists(randomLocation);
            return false;
        }
        catch (Throwable ex) {
            return true;
        }
    }
}

