/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karma.loader;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.loader.SourceAppender;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.loader.SourceLoader;

public final class SourceInjector
implements SourceAppender {
    private final SourceLoader loader;

    public SourceInjector(ClassLoader cl) {
        if (!(cl instanceof SourceLoader)) {
            throw new IllegalArgumentException("Loader is not a SubJarLoader " + cl.getClass().getName());
        }
        this.loader = (SourceLoader)cl;
    }

    @Override
    public void addSource(URL url) {
        try {
            this.loader.addJarToClasspath(url);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void addSource(URI uri) {
        try {
            this.loader.addJarToClasspath(uri.toURL());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void addSource(File file) {
        try {
            this.loader.addJarToClasspath(file.toURI().toURL());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void addSource(Path path) {
        try {
            this.loader.addJarToClasspath(path.toFile().toURI().toURL());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void close() {
        this.loader.closeLoader();
    }

    @Override
    public URLClassLoader getLoader() {
        return this.loader;
    }
}

