/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.karmayaml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.APISource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.karmayaml.KarmaYamlManager;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.reader.BoundedBufferedReader;
import org.yaml.snakeyaml.Yaml;

public final class FileCopy {
    private final Map<String, Object> keySet = new HashMap<String, Object>();
    private final Map<String, Integer> keySection = new HashMap<String, Integer>();
    private final Map<String, Integer> repeatedCount = new HashMap<String, Integer>();
    private final Map<String, Integer> repeatedCountSection = new HashMap<String, Integer>();
    private final String inFile;
    private final Class<?> main;
    private boolean debug;

    public FileCopy(KarmaSource source, String name) {
        this.inFile = name;
        this.main = source.getClass();
    }

    public FileCopy(Class<?> main, String name) {
        this.inFile = name;
        this.main = main;
    }

    public FileCopy withDebug(boolean status) {
        this.debug = status;
        return this;
    }

    public void copy(File destFile) throws IOException {
        destFile = FileUtilities.getFixedFile(destFile);
        if (this.main != null) {
            if (destFile.exists()) {
                InputStream in = this.main.getResourceAsStream("/" + this.inFile);
                if (in != null) {
                    boolean yaml;
                    InputStreamReader inReader = new InputStreamReader(in, StandardCharsets.UTF_8);
                    BoundedBufferedReader reader = new BoundedBufferedReader(inReader, Integer.MAX_VALUE, 10240);
                    String ext = FileUtilities.getExtension(destFile);
                    boolean bl = yaml = ext.equals("yml") || ext.equalsIgnoreCase("yaml");
                    if (!yaml) {
                        try {
                            Yaml yamlParser = new Yaml();
                            Map tmpYaml = (Map)yamlParser.load((Reader)reader);
                            yaml = tmpYaml != null && !tmpYaml.isEmpty();
                        }
                        catch (Throwable yamlParser) {
                            // empty catch block
                        }
                    }
                    if (yaml) {
                        String line;
                        this.fillKeySet(destFile);
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), StandardCharsets.UTF_8));
                        String last_section = "";
                        if (this.debug) {
                            APISource.getConsole().send("&b[ KarmaAPI ] &3Preparing writer for file generation ( {0} )", FileUtilities.getPrettyFile(destFile));
                        }
                        while ((line = reader.readLine()) != null) {
                            if (!line.replaceAll("\\s", "").isEmpty()) {
                                int repeatedAmount;
                                if (line.replaceAll("\\s", "").startsWith("-")) continue;
                                String key = this.getKey(line);
                                if (line.startsWith("#") || this.keySet.getOrDefault(key, null) == null || this.keySet.get(key) instanceof KarmaYamlManager) {
                                    if (this.debug) {
                                        APISource.getConsole().send("&b[ KarmaAPI ] &3Writing comment / section &e{0}", key);
                                    }
                                    writer.write(line + "\n");
                                    continue;
                                }
                                if (this.isRepeated(key)) {
                                    repeatedAmount = this.repeatedCount.getOrDefault(key, -1);
                                    if (repeatedAmount != -1) {
                                        key = key + "_" + repeatedAmount;
                                    }
                                    this.repeatedCount.put(this.getKey(line), ++repeatedAmount);
                                }
                                if (this.isSectionRepeated(key)) {
                                    last_section = key;
                                    repeatedAmount = this.repeatedCountSection.getOrDefault(key, -1);
                                    if (repeatedAmount != -1) {
                                        key = key + "_" + repeatedAmount;
                                    }
                                    this.repeatedCountSection.put(this.getKey(line), ++repeatedAmount);
                                }
                                String path = line.split(":")[0];
                                if (this.keySet.get(key) instanceof List) {
                                    List list = (List)this.keySet.get(key);
                                    if (!list.isEmpty()) {
                                        writer.write(path + ":\n");
                                        for (Object object : list) {
                                            String space = this.getSpace(last_section);
                                            writer.write(space + "- '" + object.toString().replace("'", "''") + "'\n");
                                            if (!this.debug) continue;
                                            APISource.getConsole().send("&b[ KarmaAPI ] &3Writing list value &6{0}&3 of &e{1}", object, key);
                                        }
                                        continue;
                                    }
                                    writer.write(path + ": []\n");
                                    if (!this.debug) continue;
                                    APISource.getConsole().send("&b[ KarmaAPI ] &3Written empty list &e{0}", key);
                                    continue;
                                }
                                String val = line.replace(path + ": ", "");
                                if (this.keySet.get(key) instanceof String) {
                                    writer.write(line.replace(": " + val, "") + ": '" + this.keySet.get(key).toString().replace("'", "''").replace("\"", "") + "'\n");
                                } else {
                                    writer.write(line.replace(": " + val, "") + ": " + this.keySet.get(key).toString().replace("'", "").replace("\"", "") + "\n");
                                }
                                if (!this.debug) continue;
                                APISource.getConsole().send("&b[ KarmaAPI ] &3Writing single value &6{0}&3 of &e{1}", val, key);
                                continue;
                            }
                            writer.write("\n");
                        }
                        ((Writer)writer).flush();
                        ((Writer)writer).close();
                    } else {
                        List<String> lines = Files.readAllLines(destFile.toPath());
                        StringBuilder builder = new StringBuilder();
                        for (String line : lines) {
                            if (line.replaceAll("\\s", "").isEmpty()) continue;
                            builder.append(line);
                        }
                        if (builder.toString().replaceAll("\\s", "").isEmpty()) {
                            APISource.getConsole().send("&b[ KarmaAPI ] &3Writing to {0} using in-jar file", FileUtilities.getPrettyFile(destFile));
                            in = this.main.getResourceAsStream("/" + this.inFile);
                            if (in != null) {
                                String line;
                                inReader = new InputStreamReader(in, StandardCharsets.UTF_8);
                                reader = new BoundedBufferedReader(inReader, Integer.MAX_VALUE, 10240);
                                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), StandardCharsets.UTF_8));
                                while ((line = reader.readLine()) != null) {
                                    writer.write(line + "\n");
                                }
                                ((Writer)writer).flush();
                                ((Writer)writer).close();
                            }
                        }
                    }
                    if (in != null) {
                        in.close();
                    }
                    inReader.close();
                    reader.close();
                }
            } else {
                if (!destFile.getParentFile().exists() && destFile.getParentFile().mkdirs()) {
                    APISource.getConsole().send("&b[ KarmaAPI ] &3Created directory {0}", FileUtilities.getPrettyParentFile(destFile));
                }
                if (destFile.createNewFile()) {
                    APISource.getConsole().send("&b[ KarmaAPI ] &3Writing to {0} using in-jar file", FileUtilities.getPrettyFile(destFile));
                    InputStream in = this.main.getResourceAsStream("/" + this.inFile);
                    if (in != null) {
                        String line;
                        InputStreamReader inReader = new InputStreamReader(in, StandardCharsets.UTF_8);
                        BoundedBufferedReader reader = new BoundedBufferedReader(inReader, Integer.MAX_VALUE, 10240);
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), StandardCharsets.UTF_8));
                        while ((line = reader.readLine()) != null) {
                            writer.write(line + "\n");
                        }
                        ((Writer)writer).flush();
                        ((Writer)writer).close();
                    }
                }
            }
        }
    }

    public void fix(File destFile) {
        try {
            ArrayList<String> writeTarget = new ArrayList<String>();
            destFile = FileUtilities.getFixedFile(destFile);
            List<String> lines = FileUtilities.readAllLines(destFile);
            for (int i = 0; i < lines.size(); ++i) {
                String[] keyData;
                String key;
                String value;
                int nextSpaces;
                int currentSpaces;
                String next;
                boolean written = false;
                String current = lines.get(i);
                if (!current.startsWith("#") && i != lines.size() - 1 && !(next = lines.get(i + 1)).startsWith("#") && (currentSpaces = this.countSpaces(current)) < (nextSpaces = this.countSpaces(next)) && current.contains(":") && !(value = current.replaceFirst((key = (keyData = current.split(":"))[0]) + ": ", "").replaceAll("\\s", "")).isEmpty()) {
                    writeTarget.add(key + ": ");
                    written = true;
                }
                if (written) continue;
                writeTarget.add(current);
            }
            BufferedWriter writer = Files.newBufferedWriter(destFile.toPath(), StandardCharsets.UTF_8, StandardOpenOption.CREATE);
            for (String line : writeTarget) {
                writer.write(line + "\n");
            }
            writer.flush();
            writer.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void fillKeySet(File destFile) {
        InputStream stream = this.main.getResourceAsStream("/" + this.inFile);
        KarmaYamlManager out = new KarmaYamlManager(FileUtilities.getFixedFile(destFile));
        KarmaYamlManager in = new KarmaYamlManager(stream);
        for (String key : in.getKeySet()) {
            if (in.isSection(key)) {
                KarmaYamlManager inSection = in.getSection(key);
                KarmaYamlManager outSection = out.getSection(key, inSection);
                this.fillKeySet(0, inSection, outSection);
                this.putSection(key, 0);
                continue;
            }
            if (out.isSet(key)) {
                Object outValue = out.get(key);
                if (outValue != null && in.matchesWith(key, outValue.getClass())) {
                    this.putKey(key, outValue);
                    continue;
                }
                this.putKey(key, in.get(key));
                continue;
            }
            this.putKey(key, in.get(key));
        }
    }

    private void fillKeySet(int tree, KarmaYamlManager inSection, KarmaYamlManager outSection) {
        for (String key : inSection.getKeySet()) {
            if (inSection.isSection(key)) {
                this.fillKeySet(++tree, inSection.getSection(key), outSection.getSection(key, inSection.getSection(key)));
                this.putSection(key, ++tree);
                continue;
            }
            if (outSection.isSet(key)) {
                Object outValue = outSection.get(key);
                if (outValue != null && inSection.matchesWith(key, outValue.getClass())) {
                    this.putKey(key, outValue);
                    continue;
                }
                this.putKey(key, inSection.get(key));
                continue;
            }
            this.putKey(key, inSection.get(key));
        }
    }

    private void putKey(String key, Object value) {
        if (!this.keySet.containsKey(key)) {
            this.keySet.put(key, value);
        } else {
            this.keySet.put(key + "_" + this.repeatedAmount(key), value);
        }
    }

    private void putSection(String key, int tree) {
        if (this.keySection.containsKey(key)) {
            this.keySection.put(key + "_" + this.repeatedSection(key), tree);
        } else {
            this.keySection.put(key, tree);
        }
    }

    private String getKey(String line) {
        line = line.split(":")[0];
        line = line.replaceAll("\\s", "");
        return line;
    }

    private String getSpace(String line) {
        line = line.replaceAll("[^0-9]", "").replaceAll("[0-9]", "");
        return line + "  ";
    }

    private int repeatedAmount(String key) {
        int repeated = 0;
        Iterator<String> set = this.keySet.keySet().iterator();
        if (set.hasNext()) {
            do {
                String[] keyData;
                String next;
                if (!(next = set.next()).contains("_") || !(keyData = next.split("_"))[0].equals(key)) continue;
                ++repeated;
            } while (set.hasNext());
        }
        return repeated;
    }

    private int repeatedSection(String key) {
        int repeated = 0;
        Iterator<String> set = this.keySection.keySet().iterator();
        if (set.hasNext()) {
            do {
                String[] keyData;
                String next;
                if (!(next = set.next()).contains("_") || !(keyData = next.split("_"))[0].equals(key)) continue;
                ++repeated;
            } while (set.hasNext());
        }
        return repeated;
    }

    private int countSpaces(String line) {
        char character;
        int spaces = 0;
        for (int i = 0; i < line.length() && !Character.isLetterOrDigit(character = line.charAt(i)); ++i) {
            if (!Character.isSpaceChar(character)) continue;
            ++spaces;
        }
        return spaces;
    }

    private boolean isRepeated(String key) {
        return this.repeatedAmount(key) > 0;
    }

    private boolean isSectionRepeated(String key) {
        return this.repeatedSection(key) > 0;
    }
}

