/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.karmayaml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.karmayaml.FileCopy;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.karmayaml.KYMSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.karmayaml.YamlReloader;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.reader.BoundedBufferedReader;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class KarmaYamlManager {
    @Nullable
    private final KarmaYamlManager def;
    private final Map<String, Object> map = new LinkedHashMap<String, Object>();
    private final Set<KarmaYamlManager> children = new HashSet<KarmaYamlManager>();
    private final KYMSource sourceRoot;
    private char spacer = (char)46;
    private KarmaYamlManager parent = null;
    private String root = "";

    public KarmaYamlManager(KarmaSource source, String name, String ... sub) {
        String extension;
        if (!name.endsWith(".no_extension") && StringUtils.isNullOrEmpty(extension = FileUtilities.getExtension(name))) {
            name = name + ".yml";
        }
        try {
            File file;
            String currPath = "";
            if (sub.length > 0) {
                StringBuilder pathBuilder = new StringBuilder();
                for (String path : sub) {
                    pathBuilder.append(File.separator).append(path);
                }
                currPath = pathBuilder.toString();
                file = new File(source.getDataPath().toFile() + currPath, name);
            } else {
                file = new File(source.getDataPath().toFile(), name);
            }
            if (FileUtilities.isValidFile(file)) {
                try {
                    BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                    Yaml yaml = new Yaml();
                    Map values = (Map)yaml.load((Reader)boundedBufferedReader);
                    if (values != null) {
                        this.map.putAll(values);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            } else {
                throw new RuntimeException("Tried to setup KarmaYamlManager for invalid file path/name ( Path: " + currPath + ", File name: " + name + " ) ");
            }
            this.sourceRoot = new KYMSource(file);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Tried to setup KarmaYamlManager but something went wrong ( " + ex.fillInStackTrace() + " )");
        }
        this.def = null;
    }

    public KarmaYamlManager(Reader configuration) {
        Yaml yaml = new Yaml();
        Map values = (Map)yaml.load(configuration);
        if (values != null) {
            this.map.putAll(values);
        }
        this.sourceRoot = new KYMSource(configuration);
        this.def = null;
    }

    public KarmaYamlManager(InputStream configuration) {
        Yaml yaml = new Yaml();
        Map values = (Map)yaml.load(configuration);
        if (values != null) {
            this.map.putAll(values);
        }
        this.sourceRoot = new KYMSource(configuration);
        this.def = null;
    }

    public KarmaYamlManager(String configuration, boolean isPath) {
        if (isPath) {
            File file = new File(configuration);
            try {
                BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                Yaml yaml = new Yaml();
                Map values = (Map)yaml.load((Reader)boundedBufferedReader);
                if (values != null) {
                    this.map.putAll(values);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.sourceRoot = new KYMSource(configuration, true);
        } else {
            try {
                Yaml yaml = new Yaml();
                Path file = Files.createTempFile("karmayaml", StringUtils.generateString().create(), new FileAttribute[0]);
                Files.write(file, configuration.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                Map values = (Map)yaml.load((Reader)new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8));
                if (values != null) {
                    this.map.putAll(values);
                }
                Files.deleteIfExists(file);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sourceRoot = new KYMSource(configuration, false);
        }
        this.def = null;
    }

    public KarmaYamlManager(File configuration) {
        try {
            BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(new InputStreamReader((InputStream)new FileInputStream(configuration), StandardCharsets.UTF_8));
            Yaml yaml = new Yaml();
            Map values = (Map)yaml.load((Reader)boundedBufferedReader);
            if (values != null) {
                this.map.putAll(values);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.sourceRoot = new KYMSource(configuration);
        this.def = null;
    }

    public KarmaYamlManager(Path configuration) {
        try {
            BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(new InputStreamReader((InputStream)new FileInputStream(configuration.toFile()), StandardCharsets.UTF_8));
            Yaml yaml = new Yaml();
            Map values = (Map)yaml.load((Reader)boundedBufferedReader);
            if (values != null) {
                this.map.putAll(values);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.sourceRoot = new KYMSource(configuration);
        this.def = null;
    }

    public KarmaYamlManager(Map<?, ?> values) {
        for (Object key : values.keySet()) {
            this.map.put(key.toString(), values.get(key));
        }
        this.sourceRoot = new KYMSource(values);
        this.def = null;
    }

    public KarmaYamlManager(@NotNull KarmaYamlManager defaults, KarmaSource source, String name, String ... sub) {
        String extension;
        if (!name.endsWith(".no_extension") && StringUtils.isNullOrEmpty(extension = FileUtilities.getExtension(name))) {
            name = name + ".yml";
        }
        try {
            File file;
            String currPath = "";
            if (sub.length > 0) {
                StringBuilder pathBuilder = new StringBuilder();
                for (String path : sub) {
                    pathBuilder.append(File.separator).append(path);
                }
                currPath = pathBuilder.toString();
                file = new File(source.getDataPath().toFile() + currPath, name);
            } else {
                file = new File(source.getDataPath().toFile(), name);
            }
            if (FileUtilities.isValidFile(file)) {
                try {
                    BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                    Yaml yaml = new Yaml();
                    Map values = (Map)yaml.load((Reader)boundedBufferedReader);
                    if (values != null) {
                        this.map.putAll(values);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            } else {
                throw new RuntimeException("Tried to setup KarmaYamlManager for invalid file path/name ( Path: " + currPath + ", File name: " + name + " ) ");
            }
            this.sourceRoot = new KYMSource(file);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Tried to setup KarmaYamlManager but something went wrong ( " + ex.fillInStackTrace() + " )");
        }
        this.def = defaults;
    }

    public KarmaYamlManager(@NotNull KarmaYamlManager defaults, Reader configuration) {
        Yaml yaml = new Yaml();
        Map values = (Map)yaml.load(configuration);
        if (values != null) {
            this.map.putAll(values);
        }
        this.sourceRoot = new KYMSource(configuration);
        this.def = defaults;
    }

    public KarmaYamlManager(@NotNull KarmaYamlManager defaults, InputStream configuration) {
        Yaml yaml = new Yaml();
        Map values = (Map)yaml.load(configuration);
        if (values != null) {
            this.map.putAll(values);
        }
        this.sourceRoot = new KYMSource(configuration);
        this.def = defaults;
    }

    public KarmaYamlManager(@NotNull KarmaYamlManager defaults, String configuration, boolean isPath) {
        if (isPath) {
            File file = new File(configuration);
            try {
                BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                Yaml yaml = new Yaml();
                Map values = (Map)yaml.load((Reader)boundedBufferedReader);
                if (values != null) {
                    this.map.putAll(values);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.sourceRoot = new KYMSource(configuration, true);
        } else {
            Yaml yaml = new Yaml();
            Map values = (Map)yaml.load(configuration);
            if (values != null) {
                this.map.putAll(values);
            }
            this.sourceRoot = new KYMSource(configuration, false);
        }
        this.def = defaults;
    }

    public KarmaYamlManager(@NotNull KarmaYamlManager defaults, File configuration) {
        try {
            BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(new InputStreamReader((InputStream)new FileInputStream(configuration), StandardCharsets.UTF_8));
            Yaml yaml = new Yaml();
            Map values = (Map)yaml.load((Reader)boundedBufferedReader);
            if (values != null) {
                this.map.putAll(values);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.sourceRoot = new KYMSource(configuration);
        this.def = defaults;
    }

    public KarmaYamlManager(@NotNull KarmaYamlManager defaults, Path configuration) {
        try {
            BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(new InputStreamReader((InputStream)new FileInputStream(configuration.toFile()), StandardCharsets.UTF_8));
            Yaml yaml = new Yaml();
            Map values = (Map)yaml.load((Reader)boundedBufferedReader);
            if (values != null) {
                this.map.putAll(values);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.sourceRoot = new KYMSource(configuration);
        this.def = defaults;
    }

    public KarmaYamlManager(@NotNull KarmaYamlManager defaults, Map<?, ?> values) {
        for (Object key : values.keySet()) {
            this.map.put(key.toString(), values.get(key));
        }
        this.sourceRoot = new KYMSource(values);
        this.def = defaults;
    }

    public KarmaYamlManager spacer(char spacerChar) {
        this.spacer = spacerChar;
        return this;
    }

    public void update(KarmaYamlManager configuration, boolean addNew, String ... ignore) {
        List<String> ignored = Arrays.asList(ignore);
        if (addNew) {
            for (String key : this.getKeySet()) {
                if (ignored.contains(key)) continue;
                this.set(key, configuration.get(key, this.get(key)));
            }
        } else {
            for (String key : this.getKeySet()) {
                if (ignored.contains(key)) continue;
                this.set(key, configuration.get(key, this.get(key)));
            }
        }
    }

    @NotNull
    public KarmaYamlManager set(String path, Object value) {
        if (path.contains(String.valueOf(this.spacer))) {
            String[] data = path.split(StringUtils.escapeString(String.valueOf(this.spacer)));
            String realPath = data[data.length - 1];
            data = Arrays.copyOf(data, data.length - 1);
            KarmaYamlManager last = this;
            for (String section : data) {
                last = last.getSection(section);
            }
            last.set(realPath, value);
            return last;
        }
        this.map.put(path, value);
        return this;
    }

    @NotNull
    public <T> KarmaYamlManager store(String path, T object) {
        this.set(path, StringUtils.serialize(object));
        return this;
    }

    @NotNull
    public KYMSource getSourceRoot() {
        return this.sourceRoot;
    }

    @Nullable
    public YamlReloader getReloader() {
        if (this.sourceRoot.getSource() instanceof File || this.sourceRoot.getSource() instanceof Path) {
            return new YamlReloader(this);
        }
        return null;
    }

    @NotNull
    public String getRoot() {
        return this.root;
    }

    @Nullable
    public KarmaYamlManager getParent() {
        return this.parent;
    }

    @NotNull
    public KarmaYamlManager[] getParents() {
        KarmaYamlManager parent = this.getParent();
        ArrayList<KarmaYamlManager> list = new ArrayList<KarmaYamlManager>();
        if (parent != null) {
            do {
                if ((parent = parent.getParent()) == null) continue;
                list.add(parent);
            } while (parent != null);
        }
        return list.toArray(new KarmaYamlManager[0]);
    }

    @NotNull
    public KarmaYamlManager[] getChildren() {
        ArrayList<KarmaYamlManager> childtree = new ArrayList<KarmaYamlManager>();
        for (KarmaYamlManager child : this.children) {
            childtree.add(child);
            childtree.addAll(Arrays.asList(child.getChildren()));
        }
        return childtree.toArray(new KarmaYamlManager[0]);
    }

    @NotNull
    public KarmaYamlManager getTreeMaster() {
        KarmaYamlManager parent = this.getParent();
        if (parent != null) {
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
        } else {
            parent = this;
        }
        return parent;
    }

    @NotNull
    public KarmaYamlManager save(File target) {
        if (this.parent != null) {
            return this.getTreeMaster().save(target);
        }
        for (KarmaYamlManager yaml : this.getChildren()) {
            KarmaYamlManager parentYaml = yaml.getParent();
            if (parentYaml == null) continue;
            parentYaml.set(yaml.getRoot(), yaml.map);
        }
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        try {
            Yaml yaml = new Yaml(options);
            yaml.dump(this.map, (Writer)new FileWriter(target));
            return new KarmaYamlManager(target);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return this;
        }
    }

    @NotNull
    public KarmaYamlManager save(File target, KarmaSource source, String resource) {
        this.save(target);
        try {
            FileCopy copy = new FileCopy(source, resource);
            copy.copy(target);
            return new KarmaYamlManager(target);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return this;
        }
    }

    @NotNull
    public Set<String> getKeySet() {
        return this.map.keySet();
    }

    public Object get(String path, Object def) {
        if (path.contains(String.valueOf(this.spacer))) {
            String[] data = path.split(StringUtils.escapeString(String.valueOf(this.spacer)));
            String realPath = data[data.length - 1];
            data = Arrays.copyOf(data, data.length - 1);
            KarmaYamlManager last = this;
            for (String section : data) {
                last = last.getSection(section);
            }
            return last.map.getOrDefault(realPath, def);
        }
        return this.map.getOrDefault(path, def);
    }

    @Nullable
    public Object get(String path) {
        if (path.contains(String.valueOf(this.spacer))) {
            String[] data = path.split(StringUtils.escapeString(String.valueOf(this.spacer)));
            String realPath = data[data.length - 1];
            data = Arrays.copyOf(data, data.length - 1);
            KarmaYamlManager last = this;
            for (String section : data) {
                last = last.getSection(section);
            }
            if (this.def != null) {
                return last.map.getOrDefault(realPath, this.def.get(path));
            }
            return last.map.getOrDefault(realPath, null);
        }
        if (this.def != null) {
            return this.map.getOrDefault(path, this.def.get(path));
        }
        return this.map.getOrDefault(path, null);
    }

    @NotNull
    public List<Object> getList(String path) {
        Object value = this.get(path);
        ArrayList<Object> values = new ArrayList<Object>();
        if (value instanceof List) {
            List list = (List)value;
            values.addAll(list);
        }
        return values;
    }

    @NotNull
    public List<Object> getList(String path, Object ... defaults) {
        Object value = this.get(path, Arrays.asList(defaults));
        ArrayList<Object> values = new ArrayList<Object>();
        if (value instanceof List) {
            List list = (List)value;
            values.addAll(list);
        }
        return values;
    }

    @NotNull
    public String getString(String path) {
        Object value = this.get(path);
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    public String getString(String path, String def) {
        Object value = this.get(path, def);
        if (value instanceof String) {
            return (String)value;
        }
        return def;
    }

    public int getInt(String path) {
        Object value = this.get(path);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return -1;
    }

    public int getInt(String path, int def) {
        Object value = this.get(path, def);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return def;
    }

    public double getDouble(String path) {
        Object value = this.get(path);
        if (value instanceof Double) {
            return (Double)value;
        }
        return -1.0;
    }

    public double getDouble(String path, double def) {
        Object value = this.get(path, def);
        if (value instanceof Double) {
            return (Double)value;
        }
        return def;
    }

    public long getLong(String path) {
        Object value = this.get(path);
        if (value instanceof Long) {
            return (Long)value;
        }
        return -1L;
    }

    public long getLong(String path, long def) {
        Object value = this.get(path, def);
        if (value instanceof Long) {
            return (Long)value;
        }
        return def;
    }

    public boolean getBoolean(String path) {
        Object value = this.get(path);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public boolean getBoolean(String path, boolean def) {
        Object value = this.get(path, def);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return def;
    }

    @NotNull
    public List<String> getStringList(String path) {
        List<Object> list = this.getList(path);
        ArrayList<String> values = new ArrayList<String>();
        for (Object object : list) {
            values.add(object.toString());
        }
        return values;
    }

    @NotNull
    public List<String> getStringList(String path, String ... defaults) {
        Object value = this.get(path, Arrays.asList(defaults));
        ArrayList<String> values = new ArrayList<String>();
        if (value instanceof List) {
            List list = (List)value;
            for (Object object : list) {
                values.add(object.toString());
            }
        }
        return values;
    }

    @Nullable
    public <T> T getInstance(String path) {
        return StringUtils.loadUnsafe(this.getString(path));
    }

    @NotNull
    public KarmaYamlManager getSection(String path) {
        Object value = this.get(path);
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap parsed = new LinkedHashMap();
            for (Object key : map.keySet()) {
                parsed.put(key.toString(), map.get(key));
            }
            KarmaYamlManager sub = new KarmaYamlManager(parsed);
            sub.parent = this;
            sub.root = path;
            this.children.add(sub);
            return sub;
        }
        KarmaYamlManager configuration = new KarmaYamlManager(Collections.emptyMap());
        configuration.parent = this;
        configuration.root = path;
        this.children.add(configuration);
        return configuration;
    }

    @NotNull
    public KarmaYamlManager getSection(String path, KarmaYamlManager defaults) {
        Object value = this.get(path);
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap parsed = new LinkedHashMap();
            for (Object key : map.keySet()) {
                parsed.put(key.toString(), map.get(key));
            }
            KarmaYamlManager sub = new KarmaYamlManager(parsed);
            sub.parent = this;
            sub.root = path;
            this.children.add(sub);
            return sub;
        }
        KarmaYamlManager configuration = new KarmaYamlManager(defaults.map);
        configuration.parent = this;
        configuration.root = path;
        this.children.add(configuration);
        return configuration;
    }

    public boolean isSection(String path) {
        return this.get(path, "") instanceof LinkedHashMap;
    }

    public boolean isSet(String path) {
        return this.get(path, null) != null;
    }

    public boolean matchesWith(String path, Class<?> expected) {
        Object value = this.get(path);
        if (value != null) {
            return expected.isAssignableFrom(value.getClass());
        }
        return false;
    }

    @NotNull
    public String toString() {
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        return yaml.dump(this.map);
    }

    @NotNull
    Map<String, Object> getMap() {
        return new LinkedHashMap<String, Object>(this.map);
    }
}

