/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.timer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.Scheduler;

public final class AsyncScheduler
extends Scheduler
implements Serializable {
    private static final Map<KarmaSource, Scheduler> schedulers = new ConcurrentHashMap<KarmaSource, Scheduler>();
    private final Map<Integer, Runnable> tasks = new HashMap<Integer, Runnable>();
    private final Timer scheduler;
    private Consumer<Integer> start = null;
    private Consumer<Integer> complete = null;
    private int current = 0;
    private int completed = 0;

    public AsyncScheduler(KarmaSource source) {
        AsyncScheduler async = schedulers.getOrDefault(source, null);
        if (async != null) {
            this.tasks.putAll(async.tasks);
            this.scheduler = async.scheduler;
            this.start = async.start;
            this.complete = async.complete;
            this.current = async.current;
            this.completed = async.completed;
        } else {
            this.scheduler = new Timer();
            this.scheduler.schedule(new TimerTask(){

                @Override
                public void run() {
                    int next = AsyncScheduler.this.completed + 1;
                    if (AsyncScheduler.this.tasks.containsKey(next) && AsyncScheduler.this.tasks.get(next) != null) {
                        AsyncScheduler.this.current = next;
                        if (AsyncScheduler.this.start != null) {
                            AsyncScheduler.this.start.accept(AsyncScheduler.this.current);
                        }
                        new Thread((Runnable)AsyncScheduler.this.tasks.get(next)).start();
                        AsyncScheduler.this.completed++;
                        if (AsyncScheduler.this.start != null) {
                            AsyncScheduler.this.complete.accept(AsyncScheduler.this.current);
                        }
                    }
                }
            }, 0L, 250L);
            schedulers.put(source, this);
        }
    }

    @Override
    public void onTaskStart(Consumer<Integer> taskId) {
        this.start = taskId;
    }

    @Override
    public void onTaskComplete(Consumer<Integer> taskId) {
        this.complete = taskId;
    }

    @Override
    public int queue(Runnable task) {
        int amount = this.tasks.size();
        int index = amount + 1;
        this.tasks.put(index, task);
        return index;
    }

    @Override
    public int currentTask() {
        return this.current;
    }
}

