/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.timer;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.TimeCondition;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.SimpleScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.errors.IllegalTimerAccess;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.errors.TimerAlreadyStarted;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.errors.TimerNotFound;

public final class SourceSimpleTimer
extends SimpleScheduler {
    private static final Map<Integer, SimpleScheduler> timersData = new ConcurrentHashMap<Integer, SimpleScheduler>();
    private static final Map<KarmaSource, Set<Integer>> runningTimers = new ConcurrentHashMap<KarmaSource, Set<Integer>>();
    private final long original;
    private final int id;
    private final KarmaSource source;
    private final Map<Long, Set<Runnable>> periodActions = new ConcurrentHashMap<Long, Set<Runnable>>();
    private final Map<Integer, Set<Runnable>> secondsActions = new ConcurrentHashMap<Integer, Set<Runnable>>();
    private final Map<Long, Set<Consumer<Integer>>> secondsConsumer = new ConcurrentHashMap<Long, Set<Consumer<Integer>>>();
    private final Map<Long, Set<Consumer<Long>>> periodConsumer = new ConcurrentHashMap<Long, Set<Consumer<Long>>>();
    private final Set<Runnable> onEndTasks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Runnable> onStartTasks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Runnable> onRestartTasks = Collections.newSetFromMap(new ConcurrentHashMap());
    private long back;
    private long period = 1L;
    private boolean noticeUnloaded = false;
    private boolean cancel = false;
    private boolean pause = false;
    private boolean restart;
    private boolean temp_restart = false;
    private boolean thread = false;
    private Consumer<Long> pauseAction = null;
    private Consumer<Long> cancelAction = null;

    public SourceSimpleTimer(KarmaSource owner, Number time, boolean autoRestart) {
        super(owner);
        int seconds;
        this.source = owner;
        this.restart = autoRestart;
        String value = time.toString();
        int milli = 0;
        if (value.contains(".")) {
            String[] data = value.split("\\.");
            String first = data[0];
            String millis = value.replaceFirst(first + ".", "");
            seconds = (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(first));
            if (millis.length() != 2) {
                if (millis.length() < 2) {
                    millis = millis + "000";
                }
                milli = Integer.parseInt(millis.substring(0, 2));
            } else {
                milli = Integer.parseInt(millis);
            }
        } else {
            seconds = (int)TimeUnit.SECONDS.toMillis(time.intValue());
        }
        this.back = this.original = (long)(seconds + milli);
        this.id = this.getId();
        timersData.put(this.id, this);
    }

    public SourceSimpleTimer(KarmaSource owner, int builtId) throws TimerNotFound, IllegalTimerAccess {
        super(owner);
        SimpleScheduler built = timersData.getOrDefault(builtId, null);
        if (built != null) {
            if (!built.getSource().isSource(owner)) {
                throw new IllegalTimerAccess(owner, built);
            }
        } else {
            throw new TimerNotFound(builtId);
        }
        this.source = built.getSource();
        this.restart = built.autoRestart();
        this.original = built.getOriginalTime();
        this.back = built.getMillis();
        this.id = builtId;
    }

    public SimpleScheduler noticeUnloaded(boolean status) {
        this.noticeUnloaded = status;
        return this;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    @Override
    public void pause() {
        this.pause = true;
        if (this.pauseAction != null) {
            this.runPeriodWithThread(this.pauseAction);
        }
    }

    @Override
    public void start() throws TimerAlreadyStarted {
        Set ids = runningTimers.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        if (ids.contains(this.id)) {
            throw new TimerAlreadyStarted(this);
        }
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!SourceSimpleTimer.this.pause) {
                    if (SourceSimpleTimer.this.cancel || SourceSimpleTimer.this.temp_restart) {
                        if (!SourceSimpleTimer.this.temp_restart) {
                            timersData.remove(SourceSimpleTimer.this.id);
                            Set ids = runningTimers.getOrDefault(SourceSimpleTimer.this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
                            ids.remove(SourceSimpleTimer.this.id);
                            runningTimers.put(SourceSimpleTimer.this.source, ids);
                            if (SourceSimpleTimer.this.cancelAction != null) {
                                SourceSimpleTimer.this.runPeriodWithThread(SourceSimpleTimer.this.cancelAction);
                            }
                            SourceSimpleTimer.this.cancel = false;
                            SourceSimpleTimer.this.pause = false;
                            SourceSimpleTimer.this.temp_restart = false;
                            timer.cancel();
                        } else {
                            SourceSimpleTimer.this.back = SourceSimpleTimer.this.original;
                            SourceSimpleTimer.this.onRestartTasks.forEach(x$0 -> SourceSimpleTimer.this.runTaskWithThread(x$0));
                            SourceSimpleTimer.this.temp_restart = false;
                        }
                    } else {
                        SourceSimpleTimer.this.executeTasks();
                        if (SourceSimpleTimer.this.back > 0L) {
                            SourceSimpleTimer.this.back--;
                        } else {
                            SourceSimpleTimer.this.back = SourceSimpleTimer.this.original;
                            if (SourceSimpleTimer.this.restart) {
                                SourceSimpleTimer.this.onRestartTasks.forEach(x$0 -> SourceSimpleTimer.this.runTaskWithThread(x$0));
                                SourceSimpleTimer.this.back = SourceSimpleTimer.this.original;
                            } else {
                                SourceSimpleTimer.this.onEndTasks.forEach(x$0 -> SourceSimpleTimer.this.runTaskWithThread(x$0));
                                timersData.remove(SourceSimpleTimer.this.id);
                                Set ids = runningTimers.getOrDefault(SourceSimpleTimer.this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
                                ids.remove(SourceSimpleTimer.this.id);
                                runningTimers.put(SourceSimpleTimer.this.source, ids);
                                SourceSimpleTimer.this.cancel = false;
                                SourceSimpleTimer.this.pause = false;
                                SourceSimpleTimer.this.temp_restart = false;
                                timer.cancel();
                            }
                        }
                    }
                }
            }
        }, 0L, this.period);
    }

    @Override
    public void restart() {
        this.temp_restart = true;
    }

    @Override
    public SimpleScheduler updateAutoRestart(boolean status) {
        this.restart = status;
        return this;
    }

    @Override
    public SimpleScheduler withPeriod(Number time) {
        int seconds;
        String value = time.toString();
        int milli = 0;
        if (value.contains(".")) {
            String[] data = value.split("\\.");
            String first = data[0];
            String millis = value.replaceFirst(first + ".", "");
            seconds = (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(first));
            if (millis.length() != 2) {
                if (millis.length() < 2) {
                    millis = millis + "000";
                }
                milli = Integer.parseInt(millis.substring(0, 2));
            } else {
                milli = Integer.parseInt(millis);
            }
        } else {
            seconds = (int)TimeUnit.SECONDS.toMillis(time.intValue());
        }
        this.period = seconds + milli;
        return this;
    }

    @Override
    public SimpleScheduler multiThreading(boolean status) {
        this.thread = status;
        return this;
    }

    @Override
    public SimpleScheduler exactSecondPeriodAction(int time, Runnable task) {
        Set actions = this.secondsActions.getOrDefault(time, Collections.newSetFromMap(new ConcurrentHashMap()));
        actions.add(task);
        this.secondsActions.put(time, actions);
        return this;
    }

    @Override
    public SimpleScheduler exactPeriodAction(long time, Runnable task) {
        Set actions = this.periodActions.getOrDefault(time, Collections.newSetFromMap(new ConcurrentHashMap()));
        actions.add(task);
        this.periodActions.put(time, actions);
        return this;
    }

    @Override
    public SimpleScheduler secondChangeAction(Consumer<Integer> action) {
        long second = TimeUnit.MILLISECONDS.toSeconds(this.original);
        while (second >= 0L) {
            long millis = TimeUnit.SECONDS.toMillis(second--);
            Set actions = this.secondsConsumer.getOrDefault(millis, Collections.newSetFromMap(new ConcurrentHashMap()));
            actions.add(action);
            this.secondsConsumer.put(millis, actions);
        }
        return this;
    }

    @Override
    public SimpleScheduler periodChangeAction(Consumer<Long> action) {
        long milli = this.original;
        while (milli >= 0L) {
            Set actions = this.periodConsumer.getOrDefault(milli--, Collections.newSetFromMap(new ConcurrentHashMap()));
            actions.add(action);
            this.periodConsumer.put(milli, actions);
        }
        return this;
    }

    @Override
    public SimpleScheduler cancelAction(Consumer<Long> action) {
        this.cancelAction = action;
        return this;
    }

    @Override
    public SimpleScheduler pauseAction(Consumer<Long> action) {
        this.pauseAction = action;
        return this;
    }

    @Override
    public SimpleScheduler startAction(Runnable task) {
        this.onStartTasks.add(task);
        return this;
    }

    @Override
    public SimpleScheduler endAction(Runnable task) {
        this.onEndTasks.add(task);
        return this;
    }

    @Override
    public SimpleScheduler restartAction(Runnable task) {
        this.onRestartTasks.add(task);
        return this;
    }

    @Override
    public SimpleScheduler conditionalAction(TimeCondition condition, int condition_value, Consumer<Integer> action) {
        switch (condition) {
            case EQUALS: {
                Set actions = this.secondsConsumer.getOrDefault(TimeUnit.SECONDS.toMillis(condition_value), Collections.newSetFromMap(new ConcurrentHashMap()));
                actions.add(action);
                this.secondsConsumer.put(TimeUnit.SECONDS.toMillis(condition_value), actions);
                break;
            }
            case OVER_OF: {
                long c_over_val = condition_value;
                while (c_over_val <= this.original) {
                    Set actions = this.secondsConsumer.getOrDefault(TimeUnit.SECONDS.toMillis(c_over_val++), Collections.newSetFromMap(new ConcurrentHashMap()));
                    actions.add(action);
                    this.secondsConsumer.put(c_over_val, actions);
                }
                break;
            }
            case MINUS_TO: {
                long c_minus_val = condition_value;
                while (c_minus_val >= 0L) {
                    Set actions = this.secondsConsumer.getOrDefault(TimeUnit.SECONDS.toMillis(c_minus_val--), Collections.newSetFromMap(new ConcurrentHashMap()));
                    actions.add(action);
                    this.secondsConsumer.put(c_minus_val, actions);
                }
                break;
            }
        }
        return this;
    }

    @Override
    public SimpleScheduler conditionalPeriodAction(TimeCondition condition, long condition_value, Consumer<Long> action) {
        switch (condition) {
            case EQUALS: {
                Set actions = this.periodConsumer.getOrDefault(condition_value, Collections.newSetFromMap(new ConcurrentHashMap()));
                actions.add(action);
                this.periodConsumer.put(TimeUnit.SECONDS.toMillis(condition_value), actions);
                break;
            }
            case OVER_OF: {
                long c_over_val = condition_value;
                while (c_over_val <= this.original) {
                    Set actions = this.periodConsumer.getOrDefault(c_over_val++, Collections.newSetFromMap(new ConcurrentHashMap()));
                    actions.add(action);
                    this.periodConsumer.put(c_over_val, actions);
                }
                break;
            }
            case MINUS_TO: {
                long c_minus_val = condition_value;
                while (c_minus_val >= 0L) {
                    Set actions = this.periodConsumer.getOrDefault(c_minus_val--, Collections.newSetFromMap(new ConcurrentHashMap()));
                    actions.add(action);
                    this.periodConsumer.put(c_minus_val, actions);
                }
                break;
            }
        }
        return this;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public boolean isRunning() {
        Set ids = runningTimers.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        return ids.contains(this.id);
    }

    @Override
    public boolean isPaused() {
        return this.pause;
    }

    @Override
    public boolean autoRestart() {
        return this.restart;
    }

    @Override
    public boolean isMultiThreading() {
        return this.thread;
    }

    @Override
    public long getOriginalTime() {
        return this.original;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public long getMillis() {
        return this.back;
    }

    private void executeTasks() {
        Set periodConsumers = this.periodConsumer.getOrDefault(this.back, Collections.newSetFromMap(new ConcurrentHashMap()));
        Set secondConsumers = this.secondsConsumer.getOrDefault(this.back, Collections.newSetFromMap(new ConcurrentHashMap()));
        Set runnables = this.periodActions.getOrDefault(this.back, Collections.newSetFromMap(new ConcurrentHashMap()));
        Set secondRunnable = this.secondsActions.getOrDefault((int)TimeUnit.MILLISECONDS.toSeconds(this.back), Collections.newSetFromMap(new ConcurrentHashMap()));
        runnables.addAll(secondRunnable);
        for (Consumer consumer : periodConsumers) {
            this.runPeriodWithThread(consumer);
        }
        for (Consumer consumer : secondConsumers) {
            this.runSecondsWithThread(consumer);
        }
        for (Runnable runnable : runnables) {
            this.runTaskWithThread(runnable);
        }
    }

    private void runSecondsWithThread(Consumer<Integer> task) {
        if (this.thread) {
            new Thread(() -> task.accept((int)TimeUnit.MILLISECONDS.toSeconds(this.back))).start();
        } else {
            task.accept((int)TimeUnit.MILLISECONDS.toSeconds(this.back));
        }
    }

    private void runPeriodWithThread(Consumer<Long> task) {
        if (this.thread) {
            new Thread(() -> task.accept(this.back)).start();
        } else {
            task.accept(this.back);
        }
    }

    private void runTaskWithThread(Runnable task) {
        if (this.thread) {
            new Thread(task).start();
        } else {
            task.run();
        }
    }
}

