/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.version;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.APISource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.KarmaFile;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.URLUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.ComparatorBuilder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.VersionComparator;
import ml.karmaconfigs.remote.messaging.karmaapi.common.version.VersionFetchResult;
import ml.karmaconfigs.remote.messaging.karmaapi.common.version.util.VersionCheckType;
import ml.karmaconfigs.remote.messaging.karmaapi.common.version.util.VersionResolver;

public abstract class VersionUpdater {
    private static final Map<KarmaSource, VersionFetchResult> results = new ConcurrentHashMap<KarmaSource, VersionFetchResult>();
    private KarmaSource source;
    private URL checkURL;
    private VersionCheckType versionType;
    private VersionResolver versionResolver;

    static VersionUpdater instance() {
        return new VersionUpdater(){};
    }

    public static VersionBuilder createNewBuilder(KarmaSource owner) {
        return VersionBuilder.instance(owner);
    }

    public LateScheduler<VersionFetchResult> fetch(boolean force) {
        AsyncLateScheduler<VersionFetchResult> asyncLateScheduler = new AsyncLateScheduler<VersionFetchResult>();
        if (force || !results.containsKey(this.source) || results.getOrDefault(this.source, null) == null) {
            APISource.asyncScheduler().queue(() -> {
                try {
                    boolean updated;
                    URLConnection connection = this.checkURL.openConnection();
                    InputStream file = connection.getInputStream();
                    Path temp = Files.createTempFile("kfetcher_", StringUtils.generateString().create(), new FileAttribute[0]);
                    File tempFile = FileUtilities.getFixedFile(temp.toFile());
                    tempFile.deleteOnExit();
                    if (!tempFile.exists()) {
                        Files.createFile(temp, new FileAttribute[0]);
                    }
                    Files.copy(file, temp, StandardCopyOption.REPLACE_EXISTING);
                    KarmaFile kFile = new KarmaFile(tempFile);
                    String version = kFile.getString("VERSION", this.source.version());
                    String update = kFile.getString("UPDATE", "");
                    String[] changelog = (String[])kFile.getStringList("CHANGELOG", new String[0]).toArray((Object[])new String[0]);
                    switch (this.versionType) {
                        case ID: {
                            updated = this.source.version().equals(version);
                            break;
                        }
                        case RESOLVABLE_ID: {
                            ComparatorBuilder builder = VersionComparator.createBuilder().currentVersion(this.versionResolver.resolve(this.source.version())).checkVersion(this.versionResolver.resolve(version));
                            VersionComparator comparator = StringUtils.compareTo(builder);
                            updated = comparator.isUpToDate();
                            break;
                        }
                        default: {
                            ComparatorBuilder builder = VersionComparator.createBuilder().currentVersion(this.source.version()).checkVersion(version);
                            VersionComparator comparator = StringUtils.compareTo(builder);
                            updated = comparator.isUpToDate();
                        }
                    }
                    VersionFetchResult result = new VersionFetchResult(updated, version, this.source.version(), update, changelog, this.versionResolver);
                    results.put(this.source, result);
                    asyncLateScheduler.complete(result);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    asyncLateScheduler.complete(null, ex);
                }
            });
        } else {
            asyncLateScheduler.complete(results.get(this.source));
        }
        return asyncLateScheduler;
    }

    public LateScheduler<VersionFetchResult> get() {
        AsyncLateScheduler<VersionFetchResult> asyncLateScheduler = new AsyncLateScheduler<VersionFetchResult>();
        APISource.asyncScheduler().queue(() -> {
            VersionFetchResult result = results.getOrDefault(this.source, null);
            if (result == null) {
                this.fetch(true).whenComplete(asyncLateScheduler::complete);
            } else {
                asyncLateScheduler.complete(result);
            }
        });
        return asyncLateScheduler;
    }

    public static abstract class VersionBuilder {
        private final KarmaSource source;
        private VersionCheckType versionType = VersionCheckType.NUMBER;
        private VersionResolver versionResolver;

        VersionBuilder(KarmaSource owner) {
            this.source = owner;
        }

        static VersionBuilder instance(KarmaSource owner) {
            return new VersionBuilder(owner){};
        }

        public final VersionBuilder withVersionType(VersionCheckType type) {
            this.versionType = type;
            return this;
        }

        public final VersionBuilder withVersionResolver(VersionResolver resolver) throws IllegalStateException {
            if (this.versionType != VersionCheckType.RESOLVABLE_ID) {
                throw new IllegalStateException("Cannot set version resolver for non-resolvable version check type builder");
            }
            this.versionResolver = resolver;
            return this;
        }

        protected KarmaSource getSource() {
            return this.source;
        }

        protected VersionCheckType getType() {
            return this.versionType;
        }

        protected VersionResolver getResolver() {
            return this.versionResolver;
        }

        public VersionUpdater build() throws IllegalStateException {
            if (!StringUtils.isNullOrEmpty(URLUtils.getOrNull(this.source.updateURL())) && this.source.updateURL().endsWith(".kupdter")) {
                VersionUpdater analyzer = VersionUpdater.instance();
                analyzer.source = this.source;
                analyzer.checkURL = URLUtils.getOrNull(this.source.updateURL());
                analyzer.versionType = this.versionType;
                if (this.versionType.equals((Object)VersionCheckType.RESOLVABLE_ID) && this.versionResolver == null) {
                    throw new IllegalStateException("Cannot build a version updater with null version resolver and using RESOLVABLE_ID version type");
                }
                analyzer.versionResolver = this.versionResolver;
                return analyzer;
            }
            throw new IllegalStateException("Cannot build a version updater with null/invalid version check URL ( update url must be a .kupdter file )");
        }
    }
}

