/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.worker.tcp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.Server;
import ml.karmaconfigs.remote.messaging.google.common.io.ByteArrayDataInput;
import ml.karmaconfigs.remote.messaging.google.common.io.ByteArrayDataOutput;
import ml.karmaconfigs.remote.messaging.google.common.io.ByteStreams;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.APISource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.PathUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.listener.RemoteListener;
import ml.karmaconfigs.remote.messaging.listener.ServerEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientCommandEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientConnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientDisconnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.server.ClientMessageEvent;
import ml.karmaconfigs.remote.messaging.remote.RemoteClient;
import ml.karmaconfigs.remote.messaging.util.DisconnectReason;
import ml.karmaconfigs.remote.messaging.util.WorkLevel;
import ml.karmaconfigs.remote.messaging.worker.tcp.remote.TCPRemoteClient;

public final class TCPServer
extends Server {
    private static final ByteBuffer BUFFER = ByteBuffer.allocate(4056);
    private static final Map<String, RemoteClient> clients = new ConcurrentHashMap<String, RemoteClient>();
    private static final Set<String> banned = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Set<String> connections = Collections.newSetFromMap(new ConcurrentHashMap());
    private static String server = "127.0.0.1";
    private static int sv_port = 49305;
    private static boolean debug = false;
    private static boolean operative = true;
    private static ServerSocketChannel socket;

    public TCPServer() {
    }

    public TCPServer(int port) {
        sv_port = port;
    }

    public TCPServer(String host, int port) {
        server = host;
        sv_port = port;
    }

    @Override
    public Server debug(boolean status) {
        debug = status;
        return this;
    }

    @Override
    public CompletableFuture<Boolean> start() {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Thread thread = new Thread(() -> {
            try {
                socket = ServerSocketChannel.open().bind(new InetSocketAddress(server, sv_port));
                socket.configureBlocking(false);
                result.complete(true);
                while (operative) {
                    try {
                        SocketChannel channel = socket.accept();
                        if (channel == null) continue;
                        new Thread(() -> {
                            while (channel.isConnected()) {
                                try {
                                    ByteArrayDataOutput out;
                                    ByteBuffer writeBuffer;
                                    BUFFER.clear();
                                    channel.read(BUFFER);
                                    InetAddress incoming = ((InetSocketAddress)channel.getRemoteAddress()).getAddress();
                                    int port = ((InetSocketAddress)channel.getRemoteAddress()).getPort();
                                    String default_name = incoming.getHostAddress() + "/" + port;
                                    ByteArrayDataInput input = ByteStreams.newDataInput(BUFFER.array());
                                    String mac = input.readUTF();
                                    RemoteClient client = this.getClient(default_name, mac, incoming, port, channel);
                                    if (input.readBoolean()) {
                                        String command = input.readUTF();
                                        String argument = input.readUTF();
                                        switch (command.toLowerCase()) {
                                            case "connect": {
                                                ServerEvent event;
                                                if (!banned.contains(mac)) {
                                                    if (debug) {
                                                        APISource.getConsole().send("Client {0} connected as {1}", Level.INFO, default_name, argument);
                                                    }
                                                    client = new TCPRemoteClient(argument, mac, incoming, port, channel);
                                                    clients.put(default_name, client);
                                                    connections.add(default_name);
                                                    event = new ClientConnectEvent(client);
                                                    RemoteListener.callServerEvent(event);
                                                    writeBuffer = ByteBuffer.allocate(10240);
                                                    out = ByteStreams.newDataOutput();
                                                    out.writeBoolean(true);
                                                    out.writeUTF("accept");
                                                    out.writeUTF(this.getMAC());
                                                    writeBuffer.put(out.toByteArray());
                                                    writeBuffer.flip();
                                                    channel.write(writeBuffer);
                                                    break;
                                                }
                                                ByteBuffer writeBuffer2 = ByteBuffer.allocate(10240);
                                                ByteArrayDataOutput out2 = ByteStreams.newDataOutput();
                                                out2.writeUTF(this.getMAC());
                                                out2.writeBoolean(true);
                                                out2.writeUTF("You are banned from this server!");
                                                writeBuffer2.put(out2.toByteArray());
                                                writeBuffer2.flip();
                                                channel.write(writeBuffer2);
                                                break;
                                            }
                                            case "rename": {
                                                ServerEvent event;
                                                if (connections.contains(default_name)) {
                                                    if (debug) {
                                                        APISource.getConsole().send("Client {0} is now known as {1}", Level.INFO, client.getName(), argument);
                                                    }
                                                    client = new TCPRemoteClient(argument, mac, incoming, port, channel);
                                                    clients.put(default_name, client);
                                                    event = new ClientCommandEvent(client, command, argument, BUFFER.array());
                                                    RemoteListener.callServerEvent(event);
                                                    writeBuffer = ByteBuffer.allocate(10240);
                                                    out = ByteStreams.newDataOutput();
                                                    out.writeUTF(this.getMAC());
                                                    out.writeBoolean(true);
                                                    out.writeUTF("success");
                                                    out.writeUTF("rename");
                                                    out.writeUTF(argument);
                                                    writeBuffer.put(out.toByteArray());
                                                    writeBuffer.flip();
                                                    channel.write(writeBuffer);
                                                    break;
                                                }
                                                ByteBuffer writeBuffer2 = ByteBuffer.allocate(10240);
                                                ByteArrayDataOutput out2 = ByteStreams.newDataOutput();
                                                out2.writeUTF(this.getMAC());
                                                out2.writeBoolean(true);
                                                out2.writeUTF("failed");
                                                out2.writeUTF("rename");
                                                out2.writeUTF(argument);
                                                out2.writeUTF("You are not connected to this server!");
                                                writeBuffer2.put(out2.toByteArray());
                                                writeBuffer2.flip();
                                                channel.write(writeBuffer2);
                                                break;
                                            }
                                            case "disconnect": {
                                                ServerEvent event;
                                                if (connections.contains(default_name)) {
                                                    if (debug) {
                                                        APISource.getConsole().send("Client {0} left the server ( {1} )", Level.INFO, client.getName(), argument);
                                                    }
                                                    clients.remove(default_name);
                                                    connections.remove(default_name);
                                                    event = new ClientDisconnectEvent(client, DisconnectReason.KILLED_BY_CLIENT, argument);
                                                    RemoteListener.callServerEvent(event);
                                                    break;
                                                }
                                                ByteBuffer writeBuffer2 = ByteBuffer.allocate(10240);
                                                ByteArrayDataOutput out2 = ByteStreams.newDataOutput();
                                                out2.writeUTF(this.getMAC());
                                                out2.writeBoolean(true);
                                                out2.writeUTF("failed");
                                                out2.writeUTF("disconnect");
                                                out2.writeUTF("You are not connected to this server!");
                                                writeBuffer2.put(out2.toByteArray());
                                                writeBuffer2.flip();
                                                channel.write(writeBuffer2);
                                                break;
                                            }
                                            default: {
                                                ServerEvent event;
                                                if (connections.contains(default_name)) {
                                                    if (debug) {
                                                        APISource.getConsole().send("Unknown command from {0}: {1} ( {2} )", Level.WARNING, client.getName(), command, argument);
                                                    }
                                                    event = new ClientCommandEvent(client, command, argument, BUFFER.array());
                                                    RemoteListener.callServerEvent(event);
                                                    break;
                                                }
                                                ByteBuffer writeBuffer2 = ByteBuffer.allocate(10240);
                                                ByteArrayDataOutput out2 = ByteStreams.newDataOutput();
                                                out2.writeUTF(this.getMAC());
                                                out2.writeBoolean(true);
                                                out2.writeUTF("failed");
                                                out2.writeUTF("unknown");
                                                out2.writeUTF(command);
                                                out2.writeUTF(argument);
                                                out2.writeUTF("You are not connected to this server!");
                                                writeBuffer2.put(out2.toByteArray());
                                                writeBuffer2.flip();
                                                channel.write(writeBuffer2);
                                                break;
                                            }
                                        }
                                        continue;
                                    }
                                    if (connections.contains(default_name)) {
                                        int offset = input.readInt();
                                        int max = BUFFER.array().length;
                                        ArrayList<Byte> newArray = new ArrayList<Byte>();
                                        for (int i = 0; i < max; ++i) {
                                            if (i < offset) continue;
                                            newArray.add(BUFFER.array()[i]);
                                        }
                                        byte[] fixedArray = new byte[newArray.size()];
                                        for (int i = 0; i < newArray.size(); ++i) {
                                            fixedArray[i] = (Byte)newArray.get(i);
                                        }
                                        String line = new String(fixedArray, StandardCharsets.UTF_8);
                                        writeBuffer = ByteBuffer.allocate(90128);
                                        out = ByteStreams.newDataOutput();
                                        out.writeUTF(this.getMAC());
                                        out.writeBoolean(true);
                                        out.writeUTF("success");
                                        out.writeUTF("message");
                                        out.writeUTF(client.getName());
                                        writeBuffer.put(out.toByteArray());
                                        writeBuffer.flip();
                                        channel.write(writeBuffer);
                                        ClientMessageEvent event = new ClientMessageEvent(client, fixedArray);
                                        RemoteListener.callServerEvent(event);
                                        continue;
                                    }
                                    if (debug) {
                                        APISource.getConsole().send("Denying message from {0} because he's not connected to server", Level.WARNING, default_name);
                                    }
                                    ByteBuffer writeBuffer3 = ByteBuffer.allocate(10240);
                                    ByteArrayDataOutput out3 = ByteStreams.newDataOutput();
                                    out3.writeUTF(this.getMAC());
                                    out3.writeBoolean(true);
                                    out3.writeUTF("failed");
                                    out3.writeUTF("message");
                                    out3.writeUTF("You are not connected to this server!");
                                    writeBuffer3.put(out3.toByteArray());
                                    writeBuffer3.flip();
                                    channel.write(writeBuffer3);
                                }
                                catch (Throwable ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }).start();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        System.exit(1);
                    }
                }
            }
            catch (Throwable ex) {
                result.complete(false);
            }
        });
        thread.start();
        return result;
    }

    @Override
    public String getMAC() {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] macArray = network.getHardwareAddress();
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < macArray.length; ++i) {
                str.append(String.format("%02X%s", macArray[i], i < macArray.length - 1 ? ":" : ""));
            }
            return str.toString();
        }
        catch (Throwable ex) {
            System.out.println("Failed to locate MAC address...");
            System.exit(1);
            return null;
        }
    }

    @Override
    public Set<RemoteClient> getClients() {
        return new HashSet<RemoteClient>(clients.values());
    }

    @Override
    public WorkLevel getWorkLevel() {
        return WorkLevel.TCP;
    }

    @Override
    public void close() {
        operative = false;
        try {
            socket.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void exportBans(Path destination) {
        try {
            PathUtilities.create(destination);
            String serialized = StringUtils.serialize(new ArrayList<String>(banned));
            Files.write(destination, serialized.getBytes(), StandardOpenOption.CREATE);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void loadBans(Path bans) {
        try {
            PathUtilities.create(bans);
            byte[] result = Files.readAllBytes(bans);
            Object serialized = StringUtils.load(new String(result));
            if (serialized instanceof ArrayList) {
                ArrayList list = (ArrayList)serialized;
                for (Object obj : list) {
                    this.ban(String.valueOf(obj));
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void broadcast(byte[] data) {
        for (RemoteClient client : clients.values()) {
            client.sendMessage(data);
        }
    }

    @Override
    public void redirect(String name, byte[] data) {
        for (RemoteClient client : clients.values()) {
            if (!client.getName().equals(name) && !client.getMAC().equals(name)) continue;
            client.sendMessage(data);
        }
    }

    @Override
    public void ban(String ... macAddresses) {
        banned.addAll(Arrays.asList(macAddresses));
        for (RemoteClient client : clients.values()) {
            if (!banned.contains(client.getMAC())) continue;
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(this.getMAC());
            out.writeBoolean(true);
            out.writeUTF("failed");
            out.writeUTF("disconnect");
            out.writeUTF("You have been banned from this server!");
            client.sendMessage(out.toByteArray());
        }
    }

    @Override
    public void kick(String ... macAddresses) {
        List<String> macs = Arrays.asList(macAddresses);
        for (RemoteClient client : clients.values()) {
            if (!macs.contains(client.getMAC())) continue;
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(this.getMAC());
            out.writeBoolean(true);
            out.writeUTF("failed");
            out.writeUTF("disconnect");
            out.writeUTF("You have been kicked from this server!");
            client.sendMessage(out.toByteArray());
        }
    }

    @Override
    public void unBan(String ... macAddresses) {
        Arrays.asList(macAddresses).forEach(banned::remove);
    }

    private RemoteClient getClient(String name, String mac, InetAddress address, int port, SocketChannel socket) {
        RemoteClient client = clients.getOrDefault(address.getHostAddress() + "/" + port, null);
        if (client == null) {
            client = new TCPRemoteClient(name, mac, address, port, socket);
            clients.put(address.getHostAddress() + "/" + port, client);
        }
        return client;
    }
}

