/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.worker.tcp.remote;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import ml.karmaconfigs.remote.messaging.google.common.io.ByteArrayDataOutput;
import ml.karmaconfigs.remote.messaging.google.common.io.ByteStreams;
import ml.karmaconfigs.remote.messaging.remote.RemoteServer;

public final class TCPRemoteServer
extends RemoteServer {
    private final String MAC;
    private final InetAddress host;
    private final int port;
    private final SocketChannel clientSocket;

    public TCPRemoteServer(String m3, InetAddress address, int incoming_port, SocketChannel client) {
        this.MAC = m3;
        this.host = address;
        this.port = incoming_port;
        this.clientSocket = client;
    }

    @Override
    public InetAddress getHost() {
        return this.host;
    }

    @Override
    public String getMAC() {
        return this.MAC;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean sendMessage(byte[] message) {
        try {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(this.getMAC());
            out.writeBoolean(false);
            out.writeInt(out.toByteArray().length + 4);
            out.write(message);
            ByteBuffer BUFFER = ByteBuffer.allocate(4056);
            BUFFER.put(out.toByteArray());
            BUFFER.flip();
            this.clientSocket.write(BUFFER);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

