/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging;

import ml.karmaconfigs.remote.messaging.Client;
import ml.karmaconfigs.remote.messaging.Server;
import ml.karmaconfigs.remote.messaging.util.WorkLevel;
import ml.karmaconfigs.remote.messaging.worker.tcp.TCPClient;
import ml.karmaconfigs.remote.messaging.worker.tcp.TCPServer;

public final class Factory {
    private final WorkLevel level;

    public Factory(WorkLevel lvl) {
        this.level = lvl;
    }

    public Client createClient() throws IllegalArgumentException {
        switch (this.level) {
            case TCP: {
                return new TCPClient();
            }
        }
        throw new IllegalArgumentException("UDP client is under maintenance and is not available");
    }

    public Client createClient(int target_port) throws IllegalArgumentException {
        switch (this.level) {
            case TCP: {
                return new TCPClient("127.0.0.1", target_port);
            }
        }
        throw new IllegalArgumentException("UDP client is under maintenance and is not available");
    }

    public Client createClient(String target_host, int target_port) throws IllegalArgumentException {
        switch (this.level) {
            case TCP: {
                return new TCPClient(target_host, target_port);
            }
        }
        throw new IllegalArgumentException("UDP client is under maintenance and is not available");
    }

    public Client createClient(String target_host, int target_port, int local_port) throws IllegalArgumentException {
        switch (this.level) {
            case TCP: {
                return new TCPClient(local_port, target_host, target_port);
            }
        }
        throw new IllegalArgumentException("UDP client is under maintenance and is not available");
    }

    public Server createServer(int target_port) throws IllegalArgumentException {
        switch (this.level) {
            case TCP: {
                return new TCPServer(target_port);
            }
        }
        throw new IllegalArgumentException("UDP server is under maintenance and is not available");
    }

    public Server createServer(String target_host, int target_port) throws IllegalArgumentException {
        switch (this.level) {
            case TCP: {
                return new TCPServer(target_host, target_port);
            }
        }
        throw new IllegalArgumentException("UDP server is under maintenance and is not available");
    }

    public Server createServer() throws IllegalArgumentException {
        switch (this.level) {
            case TCP: {
                return new TCPServer();
            }
        }
        throw new IllegalArgumentException("UDP server is under maintenance and is not available");
    }
}

