/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;

public final class ResourceDownloader {
    private final File destFile;
    private final String url;

    public ResourceDownloader(File destination, String _url) {
        this.destFile = destination;
        this.url = _url;
    }

    public static ResourceDownloader toCache(KarmaSource source, String fileName, String downloadURL, String ... sub) {
        File target;
        if (sub.length > 0) {
            Path dataPath = source.getDataPath();
            for (String dir : sub) {
                dataPath = dataPath.resolve(dir);
            }
            target = dataPath.resolve(fileName).toFile();
        } else {
            target = source.getDataPath().resolve("cache").resolve(fileName).toFile();
        }
        if (FileUtilities.isValidFile(target)) {
            return new ResourceDownloader(target, downloadURL);
        }
        throw new RuntimeException("Tried to download invalid resource file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void download() {
        block23: {
            Channel rbc = null;
            InputStream stream = null;
            FileOutputStream output = null;
            HttpURLConnection connection = null;
            FileUtilities.create(this.destFile);
            URL download_url2333333332 = new URL(this.url);
            connection = (HttpURLConnection)download_url2333333332.openConnection();
            connection.connect();
            stream = connection.getInputStream();
            long destSize = this.destFile.length();
            long connSize = connection.getContentLengthLong();
            if (destSize != connSize) {
                KarmaAPI.source(false).console().send((CharSequence)"Downloading file {0}", Level.INFO, this.destFile.getName());
                rbc = Channels.newChannel(download_url2333333332.openStream());
                output = new FileOutputStream(this.destFile);
                output.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, Long.MAX_VALUE);
            }
            connection.disconnect();
            try {
                if (rbc != null) {
                    rbc.close();
                }
                if (stream != null) {
                    stream.close();
                }
                if (output != null) {
                    output.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Throwable download_url2333333332) {
                // empty catch block
            }
            KarmaAPI.source(false).console().send((CharSequence)"Downloaded file {0}", Level.OK, this.destFile.getName());
            break block23;
            catch (Throwable ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        if (rbc != null) {
                            rbc.close();
                        }
                        if (stream != null) {
                            stream.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    KarmaAPI.source(false).console().send((CharSequence)"Downloaded file {0}", Level.OK, this.destFile.getName());
                    throw throwable;
                }
                try {
                    if (rbc != null) {
                        rbc.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                KarmaAPI.source(false).console().send((CharSequence)"Downloaded file {0}", Level.OK, this.destFile.getName());
            }
        }
    }

    public File getDestFile() {
        return this.destFile;
    }
}

