/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karma;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import ml.karmaconfigs.remote.messaging.karmaapi.common.Console;
import ml.karmaconfigs.remote.messaging.karmaapi.common.Logger;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.Scheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.SimpleScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.worker.AsyncScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.worker.SyncScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.KarmaLogger;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;

public interface KarmaSource
extends Serializable {
    public String name();

    public String version();

    public String description();

    public String[] authors();

    public String updateURL();

    default public void stopTasks() {
        SimpleScheduler.cancelFor(this);
    }

    default public String authors(boolean firstSeparator, String separator) {
        String[] authors = this.authors();
        StringBuilder builder = new StringBuilder();
        for (String author : authors) {
            builder.append(separator).append(author);
        }
        if (firstSeparator) {
            return builder.toString();
        }
        return builder.toString().replaceFirst(separator, "");
    }

    default public File getSourceFile() {
        File mainJar = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replaceAll("%20", " "));
        return FileUtilities.getFixedFile(mainJar);
    }

    default public Path getDataPath() {
        File mainJar = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replaceAll("%20", " "));
        File parent = mainJar.getParentFile();
        File dataFolder = StringUtils.isNullOrEmpty(this.name()) ? new File(parent, StringUtils.generateString().create()) : new File(parent, this.name());
        return dataFolder.toPath();
    }

    default public boolean isSource(KarmaSource source) {
        return this.getClass().getName().equalsIgnoreCase(source.getClass().getName()) && this.name().equals(source.name());
    }

    default public Console console() {
        return new Console(this);
    }

    default public Scheduler async() {
        return new AsyncScheduler<KarmaSource>(this);
    }

    default public Scheduler sync() {
        return new SyncScheduler<KarmaSource>(this);
    }

    default public KarmaLogger logger() {
        return new Logger(this);
    }

    default public boolean srcEquals(KarmaSource dst) {
        return dst.hashCode() == this.hashCode();
    }
}

