/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.security.token;

import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karmafile.KarmaFile;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.security.data.PBECryptoAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.security.token.exception.TokenExpiredException;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.security.token.exception.TokenIncorrectPasswordException;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.security.token.exception.TokenNotFoundException;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;

public final class TokenStorage {
    private final KarmaSource source;

    public TokenStorage(KarmaSource src) {
        this.source = src;
    }

    public void destroy(UUID tokenID, String password) {
        KarmaFile tokenFile = new KarmaFile(this.source, tokenID.toString().replace("-", ""), "cache", "tokens");
        if (tokenFile.exists() && tokenFile.isSet("TOKEN") && tokenFile.isSet("SALT")) {
            String storedToken = tokenFile.getString("TOKEN", "");
            byte[] salt = Base64.getUrlDecoder().decode(tokenFile.getString("SALT", ""));
            if (!StringUtils.isNullOrEmpty(storedToken)) {
                PBECryptoAPI api = new PBECryptoAPI(password, Base64.getUrlDecoder().decode(storedToken));
                try {
                    api.decrypt(salt);
                    tokenFile.delete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public UUID store(String token, String password, Instant expiration) {
        UUID tokenID = UUID.nameUUIDFromBytes(Base64.getUrlDecoder().decode(token));
        KarmaFile tokenFile = new KarmaFile(this.source, tokenID.toString().replace("-", ""), "cache", "tokens");
        tokenFile.create();
        PBECryptoAPI api = new PBECryptoAPI(password, Base64.getUrlDecoder().decode(token));
        byte[] salt = api.generateSALT();
        tokenFile.set("SALT", new String(Base64.getUrlEncoder().encode(salt)));
        try {
            tokenFile.set("TOKEN", new String(Base64.getUrlEncoder().encode(api.encrypt(salt))));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (expiration != null) {
            tokenFile.set("EXPIRATION", expiration.toString());
        } else {
            tokenFile.set("EXPIRATION", "N/A");
        }
        return tokenID;
    }

    public String load(UUID tokenID, String password) throws TokenNotFoundException, TokenExpiredException, TokenIncorrectPasswordException {
        KarmaFile tokenFile = new KarmaFile(this.source, tokenID.toString().replace("-", ""), "cache", "tokens");
        String token = null;
        Instant expiration = null;
        if (tokenFile.exists() && tokenFile.isSet("TOKEN") && tokenFile.isSet("SALT")) {
            String storedToken = tokenFile.getString("TOKEN", "");
            byte[] salt = Base64.getUrlDecoder().decode(tokenFile.getString("SALT", ""));
            if (!StringUtils.isNullOrEmpty(storedToken)) {
                PBECryptoAPI api = new PBECryptoAPI(password, Base64.getUrlDecoder().decode(storedToken));
                try {
                    String tmp_token = new String(api.decrypt(salt));
                    String instant = tokenFile.getString("EXPIRATION", "N/A");
                    if (!instant.equalsIgnoreCase("N/A")) {
                        expiration = Instant.parse(instant);
                        token = tmp_token;
                    }
                }
                catch (Throwable ex) {
                    throw new TokenIncorrectPasswordException(tokenID);
                }
            }
        }
        if (token != null) {
            if (expiration == null || Instant.now().isBefore(expiration)) {
                return token;
            }
            throw new TokenExpiredException(tokenID);
        }
        throw new TokenNotFoundException(tokenID);
    }

    public Instant expiration(UUID tokenID) {
        KarmaFile tokenFile = new KarmaFile(this.source, tokenID.toString().replace("-", ""), "cache", "tokens");
        String instant = tokenFile.getString("EXPIRATION", "N/A");
        if (!instant.equalsIgnoreCase("N/A")) {
            return Instant.parse(instant);
        }
        return null;
    }
}

