/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.PrefixConsoleData;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.placeholder.GlobalPlaceholderEngine;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.placeholder.SimplePlaceholder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.placeholder.util.Placeholder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.ComparatorBuilder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.OptionsBuilder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.RandomString;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.VersionComparator;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.time.CleanTimeBuilder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.time.TimeName;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    public static String replaceLast(String text, String regex, String replace) {
        try {
            return text.replaceFirst("(?s)" + regex + "(?!.*?" + regex + ")", replace);
        }
        catch (Throwable ex) {
            try {
                return StringUtils.escapeString(text).replaceFirst("(?s)" + regex + "(?!.*?" + regex + ")", replace);
            }
            catch (Throwable exc) {
                try {
                    return StringUtils.escapeString(text).replaceFirst("(?s)" + StringUtils.escapeString(regex) + "(?!.*?" + StringUtils.escapeString(regex) + ")", replace);
                }
                catch (Throwable exce) {
                    return StringUtils.escapeString(text).replaceFirst("(?s)" + StringUtils.escapeString(regex) + "(?!.*?" + StringUtils.escapeString(regex) + ")", StringUtils.escapeString(replace));
                }
            }
        }
    }

    public static String insetInEach(String text, String insert, int period) {
        String[] data;
        StringBuilder builder = new StringBuilder(text.length() + insert.length() * (text.length() / period) + 1);
        String prefix = "";
        for (int index = 0; index < text.length(); index += period) {
            builder.append(prefix);
            prefix = insert;
            builder.append(text, index, Math.min(index + period, text.length()));
        }
        StringBuilder fixed = new StringBuilder();
        for (String str : data = builder.toString().split(insert)) {
            if (str.startsWith(" ")) {
                char charAt;
                int character = 0;
                for (int i = 0; i < str.length() && Character.isSpaceChar(charAt = str.charAt(i)); ++i) {
                    ++character;
                }
                fixed.append(str.substring(character)).append(insert);
                continue;
            }
            fixed.append(str).append(insert);
        }
        return StringUtils.replaceLast(fixed.toString(), insert, "");
    }

    public static String insertInEachSpace(String text, String insert, int period, boolean replaceSpace) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (index++ < period) continue;
            char character = text.charAt(i);
            if (Character.isSpaceChar(character)) {
                builder.append(replaceSpace ? insert : character + insert);
            } else {
                builder.append(character);
            }
            index = 0;
        }
        return builder.toString();
    }

    public static String[] splitInEach(String text, int period) {
        String result = StringUtils.insetInEach(text, "\n", period);
        if (result.contains("\n")) {
            return result.split("\n");
        }
        return new String[]{result};
    }

    public static String[] splitInEachSpace(String text, int period, boolean replaceSpace) {
        String result = StringUtils.insertInEachSpace(text, "\n", period, replaceSpace);
        if (result.contains("\n")) {
            return result.split("\n");
        }
        return new String[]{result};
    }

    public static String toColor(String text) {
        String str = text;
        HashSet<String> color_codes = new HashSet<String>();
        for (int i = 0; i < text.length(); ++i) {
            char curr = text.charAt(i);
            char next = '\u0000';
            if (i + 1 != text.length()) {
                next = text.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&') continue;
            color_codes.add(String.valueOf(curr) + next);
        }
        for (String color_code : color_codes) {
            str = str.replace(color_code, color_code.replace('&', '\u00a7'));
        }
        return str;
    }

    public static String toConsoleColor(CharSequence text) {
        String str = String.valueOf(text);
        HashSet<String> color_codes = new HashSet<String>();
        for (int i = 0; i < text.length(); ++i) {
            char curr = text.charAt(i);
            char next = '\u0000';
            if (i + 1 != text.length()) {
                next = text.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
            color_codes.add(String.valueOf(curr).replace("\u00a7", "&") + next);
        }
        for (String color_code : color_codes) {
            String tmp_color = "\u001b[0m";
            switch (color_code.toLowerCase()) {
                case "&0": {
                    tmp_color = "\u001b[0;30m";
                    break;
                }
                case "&1": {
                    tmp_color = "\u001b[0;34m";
                    break;
                }
                case "&2": {
                    tmp_color = "\u001b[0;32m";
                    break;
                }
                case "&3": {
                    tmp_color = "\u001b[0;36m";
                    break;
                }
                case "&4": {
                    tmp_color = "\u001b[0;31m";
                    break;
                }
                case "&5": {
                    tmp_color = "\u001b[0;35m";
                    break;
                }
                case "&6": {
                    tmp_color = "\u001b[0;33m";
                    break;
                }
                case "&7": {
                    tmp_color = "\u001b[0;37m";
                    break;
                }
                case "&8": {
                    tmp_color = "\u001b[0;90m";
                    break;
                }
                case "&9": {
                    tmp_color = "\u001b[0;94m";
                    break;
                }
                case "&a": {
                    tmp_color = "\u001b[0;92m";
                    break;
                }
                case "&b": {
                    tmp_color = "\u001b[0;96m";
                    break;
                }
                case "&c": {
                    tmp_color = "\u001b[0;91m";
                    break;
                }
                case "&d": {
                    tmp_color = "\u001b[0;95m";
                    break;
                }
                case "&e": {
                    tmp_color = "\u001b[0;93m";
                    break;
                }
                case "&f": {
                    tmp_color = "\u001b[0;97m";
                    break;
                }
                case "&r": {
                    tmp_color = "\u001b[0m";
                }
            }
            str = str.replace(color_code, tmp_color);
        }
        return str;
    }

    public static List<String> toColor(List<String> texts) {
        ArrayList<String> newTexts = new ArrayList<String>();
        HashSet<String> color_codes = new HashSet<String>();
        for (String text : texts) {
            for (int x = 0; x < text.length(); ++x) {
                char curr = text.charAt(x);
                char next = '\u0000';
                if (x + 1 != text.length()) {
                    next = text.charAt(x + 1);
                }
                if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&') continue;
                color_codes.add(String.valueOf(curr) + next);
            }
            for (String color_code : color_codes) {
                text = text.replace(color_code, color_code.replace('&', '\u00a7'));
            }
            newTexts.add(text);
        }
        return newTexts;
    }

    public static Set<String> getColors(String text) {
        HashSet<String> color_codes = new HashSet<String>();
        for (int i = 0; i < text.length(); ++i) {
            char curr = text.charAt(i);
            char next = '\u0000';
            if (i + 1 != text.length()) {
                next = text.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&') continue;
            color_codes.add(String.valueOf(curr) + next);
        }
        return color_codes;
    }

    public static String getLastColor(String text) {
        ArrayList<String> color_codes = new ArrayList<String>();
        for (int i = 0; i < text.length(); ++i) {
            char curr = text.charAt(i);
            char next = '\u0000';
            if (i + 1 != text.length()) {
                next = text.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
            color_codes.add(String.valueOf(curr) + next);
        }
        try {
            return (String)color_codes.get(color_codes.size() - 1);
        }
        catch (Throwable ex) {
            try {
                return (String)color_codes.get(0);
            }
            catch (Throwable exc) {
                return "";
            }
        }
    }

    public static String getLastColor(List<String> texts, int index) {
        ArrayList<String> color_codes = new ArrayList<String>();
        int tmpIndex = index;
        if (index == texts.size()) {
            --tmpIndex;
        }
        if (texts.size() > tmpIndex) {
            try {
                String text = texts.get(tmpIndex);
                for (int i = 0; i < text.length(); ++i) {
                    char curr = text.charAt(i);
                    char next = '\u0000';
                    if (i + 1 != text.length()) {
                        next = text.charAt(i + 1);
                    }
                    if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
                    color_codes.add(String.valueOf(curr) + next);
                }
                try {
                    return (String)color_codes.get(color_codes.size() - 1);
                }
                catch (Throwable ex) {
                    try {
                        return (String)color_codes.get(0);
                    }
                    catch (Throwable exc) {
                        return "";
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "";
    }

    public static String stripColor(String text) {
        String str = text;
        HashSet<String> color_codes = new HashSet<String>();
        for (int i = 0; i < str.length(); ++i) {
            char curr = str.charAt(i);
            char next = '\u0000';
            if (i + 1 != str.length()) {
                next = str.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
            color_codes.add(String.valueOf(curr) + next);
        }
        for (String color_code : color_codes) {
            str = str.replace(color_code, "");
        }
        return str;
    }

    public static List<String> stripColor(List<String> texts) {
        ArrayList<String> newTexts = new ArrayList<String>();
        for (String text : texts) {
            HashSet<String> color_codes = new HashSet<String>();
            for (int x = 0; x < text.length(); ++x) {
                char curr = text.charAt(x);
                char next = '\u0000';
                if (x + 1 != text.length()) {
                    next = text.charAt(x + 1);
                }
                if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
                color_codes.add(String.valueOf(curr) + next);
            }
            for (String color_code : color_codes) {
                text = text.replace(color_code, "");
            }
            newTexts.add(text);
        }
        return newTexts;
    }

    public static RandomString generateString() {
        return new RandomString();
    }

    public static RandomString generateString(OptionsBuilder options) {
        return new RandomString(options);
    }

    public static String randomColor() {
        char[] valid_colors = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int random = new Random().nextInt(valid_colors.length);
        return "\u00a7" + valid_colors[random];
    }

    public static String formatString(CharSequence text, Object ... replaces) {
        String str = String.valueOf(text);
        for (int i = 0; i < replaces.length; ++i) {
            String placeholder = "{" + i + "}";
            Object valObj = replaces[i];
            String val = "[unknown]";
            if (valObj != null) {
                try {
                    val = valObj.toString();
                }
                catch (Throwable ex) {
                    val = String.valueOf(replaces[i]);
                }
            }
            str = str.replace(placeholder, val);
        }
        return str;
    }

    @Deprecated
    public static String formatString(CharSequence text, Map<String, Object> replaces) {
        HashSet<SimplePlaceholder<Object>> placeholders = new HashSet<SimplePlaceholder<Object>>();
        for (String key : replaces.keySet()) {
            Object value = replaces.getOrDefault(key, null);
            if (value == null) continue;
            placeholders.add(new SimplePlaceholder<Object>(key, value));
        }
        GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
        placeholders.forEach(xva$0 -> engine.forceRegister((Placeholder<?>)xva$0));
        return engine.parse(String.valueOf(text), new Object[0]);
    }

    public static String formatString(KarmaSource owner, CharSequence text, Level level) {
        String tmpMessage = String.valueOf(text);
        String prefix = "&b[ &fALERT &b] &7NONE: &b";
        PrefixConsoleData data = new PrefixConsoleData(owner);
        switch (level) {
            case OK: {
                prefix = data.getOkPrefix();
                break;
            }
            case INFO: {
                prefix = data.getInfoPrefix();
                break;
            }
            case WARNING: {
                prefix = data.getWarningPrefix();
                break;
            }
            case GRAVE: {
                prefix = data.getGravePrefix();
            }
        }
        tmpMessage = StringUtils.stripColor(tmpMessage);
        return prefix + tmpMessage;
    }

    public static String formatString(KarmaSource owner, CharSequence text, Level level, Object ... replaces) {
        String tmpMessage = String.valueOf(text);
        String prefix = "&b[ &fALERT &b] &7NONE: &b";
        PrefixConsoleData data = new PrefixConsoleData(owner);
        switch (level) {
            case OK: {
                prefix = data.getOkPrefix();
                break;
            }
            case INFO: {
                prefix = data.getInfoPrefix();
                break;
            }
            case WARNING: {
                prefix = data.getWarningPrefix();
                break;
            }
            case GRAVE: {
                prefix = data.getGravePrefix();
            }
        }
        for (int i = 0; i < replaces.length; ++i) {
            String placeholder = "{" + i + "}";
            String value = String.valueOf(replaces[i]);
            tmpMessage = tmpMessage.replace(placeholder, value);
        }
        tmpMessage = StringUtils.stripColor(tmpMessage);
        return prefix + tmpMessage;
    }

    public static String readFrom(File file) {
        try {
            byte[] encoded = Files.readAllBytes(file.toPath());
            return new String(encoded, StandardCharsets.UTF_8);
        }
        catch (Throwable ex) {
            return "";
        }
    }

    public static String listToString(List<String> lines, boolean spaces) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (spaces) {
                builder.append(line).append(i < lines.size() - 1 ? " " : "");
                continue;
            }
            builder.append(line).append(i < lines.size() - 1 ? "\n" : "");
        }
        return builder.toString();
    }

    public static String unEscapeString(String text) {
        return text.replaceAll("\\\\", "");
    }

    public static String escapeString(String text) {
        StringBuilder builder = new StringBuilder();
        block3: for (int i = 0; i < text.length(); ++i) {
            Character character = Character.valueOf(text.charAt(i));
            switch (character.charValue()) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    builder.append("\\").append(character);
                    continue block3;
                }
                default: {
                    builder.append(character);
                }
            }
        }
        return builder.toString();
    }

    public static <T> String serialize(T instance) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream so = new ObjectOutputStream(bo);
            so.writeObject(instance);
            so.flush();
            return Base64.getEncoder().encodeToString(bo.toByteArray());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "";
        }
    }

    @Nullable
    public static Object load(String instance) {
        try {
            byte[] bytes = Base64.getDecoder().decode(instance);
            ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
            ObjectInputStream si = new ObjectInputStream(bi);
            return si.readObject();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Nullable
    public static <T> T loadUnsafe(String instance) {
        return (T)StringUtils.load(instance);
    }

    public static boolean containsLetters(CharSequence sequence) {
        for (int i = 0; i < sequence.length(); ++i) {
            if (!Character.isLetter(sequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNumbers(CharSequence sequence) {
        for (int i = 0; i < sequence.length(); ++i) {
            if (!Character.isDigit(sequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(Object check) {
        if (check != null) {
            return String.valueOf(check).replaceAll("\\s", "").isEmpty() || check.toString().replaceAll("\\s", "").isEmpty();
        }
        return true;
    }

    public static boolean areNullOrEmpty(Object ... checks) {
        for (Object check : checks) {
            if (check == null) continue;
            if (!String.valueOf(check).replaceAll("\\s", "").isEmpty()) {
                if (!check.toString().replaceAll("\\s", "").isEmpty()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static VersionComparator compareTo(ComparatorBuilder builder) {
        return new VersionComparator(builder);
    }

    public static String removeNumbers(CharSequence original) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            char character = original.charAt(i);
            if (Character.isDigit(character)) continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public static String removeLetters(CharSequence original) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            char character = original.charAt(i);
            if (Character.isLetter(character)) continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public static String parseNumbers(CharSequence original, Character ... keep) {
        StringBuilder builder = new StringBuilder();
        Set<Character> chars = StringUtils.arrayToSet(keep);
        for (int i = 0; i < original.length(); ++i) {
            char character = original.charAt(i);
            if (!Character.isDigit(character) && !chars.contains(Character.valueOf(character))) continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public static String parseLetters(CharSequence original, Character ... keep) {
        StringBuilder builder = new StringBuilder();
        Set<Character> chars = StringUtils.arrayToSet(keep);
        for (int i = 0; i < original.length(); ++i) {
            char character = original.charAt(i);
            if (!Character.isLetter(character) && !chars.contains(Character.valueOf(character))) continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public static String timeToString(long milliseconds) {
        CleanTimeBuilder builder = new CleanTimeBuilder(TimeName.create(), milliseconds);
        return builder.create();
    }

    public static String timeToString(long milliseconds, TimeName name) {
        CleanTimeBuilder builder = new CleanTimeBuilder(name, milliseconds);
        return builder.create();
    }

    public static <T> Set<T> arrayToSet(T[] array) {
        return new HashSet<T>(Arrays.asList(array));
    }
}

