/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import ml.karmaconfigs.remote.messaging.google.gson.Gson;
import ml.karmaconfigs.remote.messaging.google.gson.GsonBuilder;
import ml.karmaconfigs.remote.messaging.google.gson.JsonElement;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;

public final class HttpUtil {
    private final URI url;

    HttpUtil(URL target) throws URISyntaxException {
        this.url = target.toURI();
    }

    public void push() {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpget = new HttpGet(this.url);
            httpclient.execute((HttpUriRequest)httpget);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    public String getResponse() {
        String response = "";
        try {
            CloseableHttpClient httpclient = HttpClientBuilder.create().disableRedirectHandling().build();
            HttpGet httpget = new HttpGet(this.url);
            CloseableHttpResponse httpresponse = httpclient.execute((HttpUriRequest)httpget);
            Header[] contentType = httpresponse.getHeaders("Content-type");
            boolean json = false;
            for (Header header : contentType) {
                if (!header.getValue().equalsIgnoreCase("application/json")) continue;
                json = true;
                break;
            }
            Scanner sc = new Scanner(httpresponse.getEntity().getContent());
            StringBuilder sb = new StringBuilder();
            while (sc.hasNext()) {
                sb.append(sc.next());
            }
            response = sb.toString();
            if (json) {
                Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                JsonElement object = (JsonElement)gson.fromJson(response, JsonElement.class);
                response = gson.toJson(object);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return response;
    }
}

