/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.uuid;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import ml.karmaconfigs.remote.messaging.google.gson.Gson;
import ml.karmaconfigs.remote.messaging.google.gson.GsonBuilder;
import ml.karmaconfigs.remote.messaging.google.gson.JsonArray;
import ml.karmaconfigs.remote.messaging.google.gson.JsonElement;
import ml.karmaconfigs.remote.messaging.google.gson.JsonObject;
import ml.karmaconfigs.remote.messaging.google.gson.JsonPrimitive;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url.HttpUtil;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url.URLUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.uuid.OKAResponse;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.uuid.UUIDType;
import org.jetbrains.annotations.Nullable;

public final class UUIDUtil {
    public static void registerMinecraftClient(String name) {
        HttpUtil utils;
        int response_code;
        URL first = URLUtils.getOrNull("https://karmadev.es/?nick=" + name);
        URL second = URLUtils.getOrNull("https://karmarepo.000webhostapp.com/api/?nick=" + name);
        if (first != null && (response_code = URLUtils.getResponseCode("https://karmadev.es")) == 200 && (utils = URLUtils.extraUtils(first)) != null) {
            utils.push();
        }
        if (second != null && (response_code = URLUtils.getResponseCode("https://karmarepo.000webhostapp.com")) == 200 && (utils = URLUtils.extraUtils(second)) != null) {
            utils.push();
        }
    }

    public static UUID fetch(String name, UUIDType type) {
        switch (type) {
            case ONLINE: {
                try {
                    URL url = URLUtils.getOrBackup("https://api.mojang.com/users/profiles/minecraft/" + name, "https://minecraft-api.com/api/uuid/" + name, "https://api.minetools.eu/uuid/" + name, "https://karmadev.es/?nick=" + name, "https://karmarepo.000webhostapp.com/api/?nick=" + name);
                    if (url != null) {
                        JsonPrimitive primitive;
                        JsonElement element;
                        Gson gson;
                        JsonObject json;
                        String urlStr = url.toString();
                        String result = null;
                        InputStream response = url.openStream();
                        InputStreamReader responseReader = new InputStreamReader(response, StandardCharsets.UTF_8);
                        BufferedReader reader = new BufferedReader(responseReader);
                        if ((urlStr.equalsIgnoreCase("https://api.mojang.com/users/profiles/minecraft/" + name) || urlStr.equalsIgnoreCase("https://api.minetools.eu/uuid/" + name)) && (json = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson((Reader)reader, JsonObject.class)).has("id") && (element = json.get("id")).isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString() && (result = primitive.getAsString()).equalsIgnoreCase("null")) {
                            result = null;
                        }
                        if (urlStr.equalsIgnoreCase("https://minecraft-api.com/api/uuid/" + name)) {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                result = line.replaceAll("\\s", "");
                            }
                        }
                        reader.close();
                        responseReader.close();
                        response.close();
                        if (result != null && result.equalsIgnoreCase("Playernotfound!")) {
                            result = null;
                        }
                        return UUIDUtil.fromTrimmed(result);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes());
            }
        }
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes());
    }

    public static String fetchNick(UUID uuid) {
        String result = null;
        try {
            JsonPrimitive primitive;
            JsonElement element;
            Gson gson;
            JsonObject json;
            String response;
            HttpUtil utils;
            URL url = URLUtils.getOrBackup("https://karmadev.es/api/?fetch=" + uuid, "https://karmarepo.000webhostapp.com/api/?fetch=" + uuid);
            if (url != null && (utils = URLUtils.extraUtils(url)) != null && !StringUtils.isNullOrEmpty(response = utils.getResponse()) && (json = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson(response, JsonObject.class)).has("name") && (element = json.get("name")).isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString() && (result = primitive.getAsString()).equals("unknown")) {
                result = null;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Nullable
    public static OKAResponse fetchOKA(String name) {
        OKAResponse result;
        block6: {
            result = null;
            try {
                Gson gson;
                JsonObject json;
                String response;
                HttpUtil utils;
                URL url = URLUtils.getOrBackup("https://karmadev.es/api/?fetch=" + name, "https://karmarepo.000webhostapp.com/api/?fetch=" + name);
                if (url == null || (utils = URLUtils.extraUtils(url)) == null || StringUtils.isNullOrEmpty(response = utils.getResponse()) || !(json = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson(response, JsonObject.class)).has("name")) break block6;
                String nick = json.get("nick").getAsString();
                UUID off = null;
                UUID on = null;
                JsonArray offline = json.get("offline").getAsJsonArray();
                JsonArray online = json.get("online").getAsJsonArray();
                JsonObject offlineData = offline.get(0).getAsJsonObject().get("data").getAsJsonObject();
                JsonObject onlineData = online.get(0).getAsJsonObject().get("data").getAsJsonObject();
                try {
                    off = UUID.fromString(offlineData.get("id").getAsString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    on = UUID.fromString(onlineData.get("id").getAsString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result = new OKAResponse(nick, off, on);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Nullable
    public static OKAResponse fetchOKAId(UUID id) {
        String nick = UUIDUtil.fetchNick(id);
        return UUIDUtil.fetchOKA(nick);
    }

    public static int getStored() {
        try {
            JsonPrimitive primitive;
            JsonElement element;
            Gson gson;
            JsonObject json;
            String response;
            HttpUtil utils;
            URL url = URLUtils.getOrBackup("https://karmadev.es/api/?fetch=@all", "https://karmarepo.000webhostapp.com/api/?fetch=@all");
            if (url != null && (utils = URLUtils.extraUtils(url)) != null && !StringUtils.isNullOrEmpty(response = utils.getResponse()) && (json = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson(response, JsonObject.class)).has("stored") && (element = json.get("stored")).isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isNumber()) {
                return primitive.getAsNumber().intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public static Set<OKAResponse> fetchAll() {
        HashSet<OKAResponse> result = new HashSet<OKAResponse>();
        try {
            JsonElement element;
            Gson gson;
            JsonObject json;
            String response;
            HttpUtil utils;
            URL url = URLUtils.getOrBackup("https://karmadev.es/api/?fetch=@all", "https://karmarepo.000webhostapp.com/api/?fetch=@all");
            if (url != null && (utils = URLUtils.extraUtils(url)) != null && !StringUtils.isNullOrEmpty(response = utils.getResponse()) && (json = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson(response, JsonObject.class)).has("fetched") && (element = json.get("fetched")).isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                for (JsonElement data : array) {
                    if (!data.isJsonObject()) continue;
                    JsonObject obj = data.getAsJsonObject();
                    obj.entrySet().forEach(account -> {
                        String nick = (String)account.getKey();
                        UUID off = null;
                        UUID on = null;
                        JsonObject info = ((JsonElement)account.getValue()).getAsJsonObject();
                        JsonArray offline = info.getAsJsonArray("offline");
                        JsonArray online = info.getAsJsonArray("online");
                        JsonObject offlineData = offline.get(0).getAsJsonObject().get("data").getAsJsonObject();
                        JsonObject onlineData = online.get(0).getAsJsonObject().get("data").getAsJsonObject();
                        try {
                            off = UUID.fromString(offlineData.get("id").getAsString());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            on = UUID.fromString(onlineData.get("id").getAsString());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        OKAResponse tmp = new OKAResponse(nick, off, on);
                        result.add(tmp);
                    });
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    @Nullable
    public static UUID fromTrimmed(String id) {
        UUID result;
        if (!StringUtils.isNullOrEmpty(id)) {
            if (!id.contains("-")) {
                StringBuilder builder = new StringBuilder(id);
                builder.insert(20, "-");
                builder.insert(16, "-");
                builder.insert(12, "-");
                builder.insert(8, "-");
                result = UUID.fromString(builder.toString());
            } else {
                result = UUID.fromString(id);
            }
        } else {
            result = null;
        }
        return result;
    }

    static {
        KarmaAPI.install();
    }
}

