/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.util.message;

import java.io.Serializable;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.util.message.MessageInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageOutput;
import ml.karmaconfigs.remote.messaging.util.message.type.DataType;
import org.jetbrains.annotations.Nullable;

public class MessageDataInput
extends MessageInput {
    private final MessageOutput input;

    public MessageDataInput(byte[] data) {
        super(data);
        String serialized = new String(data);
        this.input = (MessageOutput)StringUtils.loadUnsafe(serialized);
    }

    public MessageDataInput(MessageOutput out) {
        super(out);
        this.input = out;
    }

    @Override
    @Nullable
    public Serializable getSerialized(String key) {
        return (Serializable)this.input.get(key, DataType.SERIALIZABLE);
    }

    @Override
    @Nullable
    public CharSequence getSequence(String key) {
        return (CharSequence)this.input.get(key, DataType.SEQUENCE);
    }

    @Override
    public boolean getBoolean(String key) {
        return Boolean.TRUE.equals(this.input.get(key, DataType.BOOLEAN));
    }

    @Override
    @Nullable
    public Number getNumber(String key) {
        return (Number)this.input.get(key, DataType.NUMBER);
    }

    @Override
    public char[] getCharacters(String key) {
        return (char[])this.input.get(key, DataType.CHARACTER);
    }

    @Override
    public byte[] getBytes(String key) {
        return (byte[])this.input.get(key, DataType.BYTE);
    }
}

