/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.worker.tcp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.Client;
import ml.karmaconfigs.remote.messaging.karmaapi.common.Console;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.LateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.worker.AsyncLateScheduler;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.PrefixConsoleData;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.listener.ClientEvent;
import ml.karmaconfigs.remote.messaging.listener.RemoteListener;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerConnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerDisconnectEvent;
import ml.karmaconfigs.remote.messaging.listener.event.client.ServerMessageEvent;
import ml.karmaconfigs.remote.messaging.remote.RemoteServer;
import ml.karmaconfigs.remote.messaging.util.WorkLevel;
import ml.karmaconfigs.remote.messaging.util.message.DataFixer;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataOutput;
import ml.karmaconfigs.remote.messaging.util.message.MessageInput;
import ml.karmaconfigs.remote.messaging.util.message.MessageOutput;
import ml.karmaconfigs.remote.messaging.util.message.type.MergeType;
import ml.karmaconfigs.remote.messaging.worker.tcp.remote.TCPRemoteServer;

public final class TCPClient
extends Client {
    private static final Set<byte[]> data_queue = Collections.newSetFromMap(new ConcurrentHashMap());
    private static RemoteServer remote = null;
    private static String client_name = "client_" + new Random().nextInt(Integer.MAX_VALUE);
    private static String server = "127.0.0.1";
    private static String key = "";
    private static int sv_port = 49305;
    private static int client = 49300;
    private static boolean debug = false;
    private static boolean operative = false;
    private static boolean instant_close = false;
    private static boolean award_connection = false;
    private static boolean tryingConnect = true;
    private static SocketChannel socket;
    private final Console console = new Console(this);

    public TCPClient() {
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[TCP Client (&aOK&3)]&b ");
        data.setInfoPrefix("&3[TCP Client (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[TCP Client (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[TCP Client (&4ERROR&3)]&b ");
    }

    public TCPClient(String server_host, int server_port) {
        server = server_host;
        sv_port = server_port;
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[TCP Client (&aOK&3)]&b ");
        data.setInfoPrefix("&3[TCP Client (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[TCP Client (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[TCP Client (&4ERROR&3)]&b ");
    }

    public TCPClient(int client_port, String server_host, int server_port) {
        client = client_port;
        server = server_host;
        sv_port = server_port;
        PrefixConsoleData data = this.console.getData();
        data.setOkPrefix("&3[TCP Client (&aOK&3)]&b ");
        data.setInfoPrefix("&3[TCP Client (&7INFO&3)]&b ");
        data.setWarnPrefix("&3[TCP Client (&eWARNING&3)]&b ");
        data.setGravePrefix("&3[TCP Client (&4ERROR&3)]&b ");
    }

    @Override
    public Client debug(boolean status) {
        debug = status;
        return this;
    }

    @Override
    public LateScheduler<Boolean> connect() {
        if (!operative) {
            AsyncLateScheduler<Boolean> result = new AsyncLateScheduler<Boolean>();
            Thread thread = new Thread(() -> {
                try {
                    ClientEvent event;
                    MessageDataInput input;
                    Object readBuffer;
                    ByteBuffer tmpBuffer;
                    int read;
                    if (debug) {
                        this.console.send((CharSequence)"Initializing the connection with the server", Level.INFO);
                    }
                    socket = SocketChannel.open().bind(new InetSocketAddress(client));
                    socket.configureBlocking(false);
                    socket.connect(new InetSocketAddress(server, sv_port));
                    while (!socket.finishConnect()) {
                        if (!tryingConnect) continue;
                        if (debug) {
                            this.console.send((CharSequence)"Trying to establish a connection with {0}/{1}", Level.INFO, server, sv_port);
                        }
                        tryingConnect = false;
                    }
                    award_connection = true;
                    tryingConnect = true;
                    if (debug) {
                        this.console.send((CharSequence)"The connection has been established but the client is still waiting for server confirmation, data can be started to be sent", Level.WARNING, server, sv_port);
                    }
                    while (award_connection) {
                        if (instant_close) {
                            this.close();
                            tryingConnect = false;
                            award_connection = false;
                            operative = false;
                        }
                        if (tryingConnect) {
                            MessageDataOutput output = new MessageDataOutput();
                            ((MessageOutput)output).write("MAC", this.getMAC());
                            ((MessageOutput)output).write("COMMAND_ENABLED", true);
                            ((MessageOutput)output).write("COMMAND", "connect");
                            ((MessageOutput)output).write("ARGUMENT", client_name);
                            if (!StringUtils.isNullOrEmpty(key)) {
                                ((MessageOutput)output).write("ACCESS_KEY", key);
                            }
                            byte[] compile = ((MessageOutput)output).compile();
                            ByteBuffer tmp = ByteBuffer.wrap(compile);
                            socket.write(tmp);
                            tryingConnect = false;
                        }
                        if ((read = socket.read(tmpBuffer = ByteBuffer.allocate(5120))) == 0) continue;
                        readBuffer = DataFixer.fixBuffer(tmpBuffer);
                        if (operative || !((MessageInput)(input = new MessageDataInput(((ByteBuffer)readBuffer).array()))).getBoolean("COMMAND_ENABLED")) continue;
                        String sequence = input.getString("COMMAND");
                        String mac = input.getString("MAC");
                        if (sequence == null || mac == null) continue;
                        if (sequence.equalsIgnoreCase("accept")) {
                            remote = new TCPRemoteServer(mac, InetAddress.getByName(server), sv_port, socket);
                            if (debug) {
                                this.console.send((CharSequence)"Connection has been validated by the server", Level.OK);
                            }
                            for (byte[] data : data_queue) {
                                ByteBuffer tmp = ByteBuffer.wrap(data);
                                socket.write(tmp);
                                data_queue.remove(data);
                            }
                            award_connection = false;
                            operative = true;
                            event = new ServerConnectEvent(remote);
                            RemoteListener.callClientEvent(event);
                            continue;
                        }
                        String argument = input.getString("ARGUMENT");
                        if (argument == null || !argument.equalsIgnoreCase("connect")) continue;
                        instant_close = true;
                        result.complete(false);
                        String reason = input.getString("COMMAND_ARGUMENT");
                        if (reason == null) continue;
                        this.console.send((CharSequence)"Connection has been declined by the server ({0})", Level.GRAVE, reason);
                    }
                    result.complete(true);
                    block39: while (operative) {
                        tmpBuffer = ByteBuffer.allocate(4056);
                        read = socket.read(tmpBuffer);
                        if (read == 0) {
                            for (byte[] queue : data_queue) {
                                ByteBuffer tmp = ByteBuffer.wrap(queue);
                                socket.write(tmp);
                                data_queue.remove(queue);
                            }
                            continue;
                        }
                        readBuffer = DataFixer.fixBuffer(tmpBuffer);
                        input = new MessageDataInput(((ByteBuffer)readBuffer).array());
                        String mac = input.getString("MAC");
                        boolean isCommand = ((MessageInput)input).getBoolean("COMMAND_ENABLED");
                        if (!remote.getMAC().equals(mac)) continue;
                        if (isCommand) {
                            String command = input.getString("COMMAND");
                            String argument = input.getString("ARGUMENTS");
                            if (command == null || argument == null) continue;
                            switch (command.toLowerCase()) {
                                case "success": {
                                    String data;
                                    switch (argument.toLowerCase()) {
                                        case "rename": {
                                            client_name = input.getString("ARGUMENT_DATA");
                                            if (client_name == null || !debug) continue block39;
                                            this.console.send((CharSequence)"Server accepted the new client name: {0}", Level.OK, client_name);
                                            break;
                                        }
                                        case "message": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null || !debug) continue block39;
                                            this.console.send((CharSequence)"{0} to server: {1}", Level.INFO, data, new String(((ByteBuffer)readBuffer).array()));
                                            break;
                                        }
                                        case "unknown": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null || !debug) continue block39;
                                            String[] arg_data = data.split(",");
                                            this.console.send((CharSequence)"{0} ran custom command: {1} ( {2} )", Level.WARNING, arg_data[0], arg_data[1], arg_data[2]);
                                            break;
                                        }
                                        default: {
                                            if (!debug) continue block39;
                                            this.console.send((CharSequence)"Unknown command from server: {0} ( {1} )", Level.GRAVE, command, argument);
                                            break;
                                        }
                                    }
                                    continue block39;
                                }
                                case "failed": {
                                    String data;
                                    switch (argument.toLowerCase()) {
                                        case "connect": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null) continue block39;
                                            String[] connect_data = data.split(",");
                                            String name = connect_data[0];
                                            String reason = connect_data[1];
                                            this.console.send((CharSequence)"Server declined connection as {0}, because: {1}", Level.GRAVE, name, reason);
                                            ServerDisconnectEvent connectEvent = new ServerDisconnectEvent(remote, reason);
                                            RemoteListener.callClientEvent(connectEvent);
                                            break;
                                        }
                                        case "rename": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null) continue block39;
                                            String[] rename_data = data.split(",");
                                            this.console.send((CharSequence)"Failed to change client name to {0}: {1}", Level.GRAVE, rename_data[0], rename_data[1]);
                                            break;
                                        }
                                        case "disconnect": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null) continue block39;
                                            this.console.send((CharSequence)"Failed while trying to disconnect the server ( you've been disconnected anyway ): {0}", Level.GRAVE, data);
                                            ServerDisconnectEvent disconnectEvent = new ServerDisconnectEvent(remote, "no server reason...");
                                            RemoteListener.callClientEvent(disconnectEvent);
                                            break;
                                        }
                                        case "message": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null) continue block39;
                                            this.console.send((CharSequence)"Failed while trying to send a message to server: {0}", Level.GRAVE, data);
                                            break;
                                        }
                                        case "unknown": {
                                            data = input.getString("ARGUMENT_DATA");
                                            if (data == null) continue block39;
                                            String[] unknown_data = data.split(",");
                                            this.console.send((CharSequence)"Failed while trying to execute custom command {0} with argument {1}: {2}", Level.GRAVE, unknown_data[0], unknown_data[1], unknown_data[2]);
                                            break;
                                        }
                                        default: {
                                            if (!debug) continue block39;
                                            this.console.send((CharSequence)"Unknown command from server: {0} ( {1} )", Level.WARNING, command, argument);
                                            break;
                                        }
                                    }
                                    continue block39;
                                }
                                case "disconnect": {
                                    String reason = input.getString("ARGUMENT_DATA");
                                    if (reason != null) {
                                        this.console.send((CharSequence)"Connection killed by server: {0}", Level.GRAVE, reason);
                                    }
                                    ServerDisconnectEvent event2 = new ServerDisconnectEvent(remote, reason);
                                    RemoteListener.callClientEvent(event2);
                                    this.close();
                                }
                            }
                            continue;
                        }
                        event = new ServerMessageEvent(remote, input);
                        RemoteListener.callClientEvent(event);
                    }
                }
                catch (Throwable ex) {
                    result.complete(false, ex);
                }
            });
            thread.start();
            return result;
        }
        return null;
    }

    @Override
    public LateScheduler<Boolean> connect(String accessKey) {
        if (!operative) {
            key = accessKey;
            return this.connect();
        }
        return null;
    }

    @Override
    public String getName() {
        return client_name;
    }

    @Override
    public String getMAC() {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] macArray = network.getHardwareAddress();
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < macArray.length; ++i) {
                str.append(String.format("%02X%s", macArray[i], i < macArray.length - 1 ? ":" : ""));
            }
            return str.toString();
        }
        catch (Throwable ex) {
            System.out.println("Failed to locate MAC address...");
            System.exit(1);
            return null;
        }
    }

    @Override
    public RemoteServer getServer() {
        return remote;
    }

    @Override
    public WorkLevel getWorkLevel() {
        return WorkLevel.TCP;
    }

    @Override
    public void rename(String name) {
        if (award_connection || operative) {
            client_name = name;
            MessageDataOutput output = new MessageDataOutput();
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", true);
            ((MessageOutput)output).write("COMMAND", "rename");
            ((MessageOutput)output).write("ARGUMENT", client_name);
            try {
                if (debug) {
                    this.console.send((CharSequence)"Trying to inform the server about the name change request to {0}", Level.INFO, name);
                }
                byte[] compile = ((MessageOutput)output).compile();
                ByteBuffer tmp = ByteBuffer.wrap(compile);
                socket.write(tmp);
            }
            catch (Throwable ex) {
                data_queue.add(((MessageOutput)output).compile());
            }
        }
    }

    @Override
    public void send(byte[] data) {
        if (award_connection || operative) {
            MessageDataOutput output = new MessageDataOutput(data, MergeType.DIFFERENCE);
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", false);
            try {
                byte[] compile = ((MessageOutput)output).compile();
                ByteBuffer tmp = ByteBuffer.wrap(compile);
                socket.write(tmp);
            }
            catch (Throwable ex) {
                data_queue.add(((MessageOutput)output).compile());
            }
        }
    }

    @Override
    public void close() {
        if (operative) {
            try {
                MessageDataOutput output = new MessageDataOutput();
                ((MessageOutput)output).write("MAC", this.getMAC());
                ((MessageOutput)output).write("COMMAND_ENABLED", true);
                ((MessageOutput)output).write("COMMAND", "disconnect");
                ((MessageOutput)output).write("ARGUMENT", "Client disconnect request");
                data_queue.add(((MessageOutput)output).compile());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else {
            instant_close = true;
        }
    }

    @Override
    public String name() {
        return "TCP Client";
    }

    @Override
    public String version() {
        return "0";
    }

    @Override
    public String description() {
        return "TCP client to connect to a TCP server that has been created with RemoteMessaging API";
    }

    @Override
    public String[] authors() {
        return new String[]{"KarmaDev"};
    }

    @Override
    public String updateURL() {
        return null;
    }
}

