/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.time;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.KarmaUnit;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.time.TimeName;

public final class CleanTimeBuilder {
    private final TimeName name;
    private final long milliseconds;

    public CleanTimeBuilder(TimeName n, long time) {
        this.name = n;
        this.milliseconds = time;
    }

    public String create() {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(this.milliseconds);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(this.milliseconds);
        long hours = TimeUnit.MILLISECONDS.toHours(this.milliseconds);
        long days = TimeUnit.MILLISECONDS.toDays(this.milliseconds);
        long tmp_weeks = days / 7L;
        long tmp_months = tmp_weeks / 4L;
        long tmp_years = tmp_months / 12L;
        long weeks = Math.round(tmp_weeks);
        long months = Math.round(tmp_months);
        long year = Math.round(tmp_years);
        int month = (int)(year != 0L ? Math.abs(year * 12L - months) : months);
        int week = (int)(months != 0L ? Math.abs(months * 4L - weeks) : weeks);
        int day = (int)(weeks != 0L ? Math.abs(weeks * 7L - days) : days);
        int hour = (int)(days != 0L ? Math.abs(days * 24L - hours) : hours);
        int minute = (int)(hours != 0L ? Math.abs(hours * 60L - minutes) : minutes);
        int second = (int)(minutes != 0L ? Math.abs(minutes * 60L - seconds) : seconds);
        int[] numbers = new int[]{(int)year, month, week, day, hour, minute, second};
        int index = 0;
        ArrayList<String> times = new ArrayList<String>();
        for (int number : numbers) {
            switch (index) {
                case 0: {
                    if (number <= 0) break;
                    if (number == 1) {
                        times.add(number + " " + this.name.get(KarmaUnit.YEAR));
                        break;
                    }
                    times.add(number + " " + this.name.get(KarmaUnit.YEARS));
                    break;
                }
                case 1: {
                    if (number <= 0) break;
                    if (number == 1) {
                        times.add(number + " " + this.name.get(KarmaUnit.MONTH));
                        break;
                    }
                    times.add(number + " " + this.name.get(KarmaUnit.MONTHS));
                    break;
                }
                case 2: {
                    if (number <= 0) break;
                    if (number == 1) {
                        times.add(number + " " + this.name.get(KarmaUnit.WEEK));
                        break;
                    }
                    times.add(number + " " + this.name.get(KarmaUnit.WEEKS));
                    break;
                }
                case 3: {
                    if (number <= 0) break;
                    if (number == 1) {
                        times.add(number + " " + this.name.get(KarmaUnit.DAY));
                        break;
                    }
                    times.add(number + " " + this.name.get(KarmaUnit.DAYS));
                    break;
                }
                case 4: {
                    if (number <= 0) break;
                    if (number == 1) {
                        times.add(number + " " + this.name.get(KarmaUnit.HOUR));
                        break;
                    }
                    times.add(number + " " + this.name.get(KarmaUnit.HOURS));
                    break;
                }
                case 5: {
                    if (number <= 0) break;
                    if (number == 1) {
                        times.add(number + " " + this.name.get(KarmaUnit.MINUTE));
                        break;
                    }
                    times.add(number + " " + this.name.get(KarmaUnit.MINUTES));
                    break;
                }
                case 6: {
                    if (number <= 0) break;
                    if (number == 1) {
                        times.add(number + " " + this.name.get(KarmaUnit.SECOND));
                        break;
                    }
                    times.add(number + " " + this.name.get(KarmaUnit.SECONDS));
                    break;
                }
            }
            ++index;
        }
        if (!times.isEmpty()) {
            index = 0;
            StringBuilder builder = new StringBuilder();
            for (String time : times) {
                builder.append(time);
                if (++index == times.size()) continue;
                if (index == times.size() - 1) {
                    builder.append(" and ");
                    continue;
                }
                builder.append(", ");
            }
            return builder.toString();
        }
        return String.valueOf(this.milliseconds);
    }
}

