/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.worker.ssl.remote;

import java.net.InetAddress;
import java.net.Socket;
import ml.karmaconfigs.remote.messaging.remote.RemoteServer;
import ml.karmaconfigs.remote.messaging.util.message.MessageDataOutput;
import ml.karmaconfigs.remote.messaging.util.message.MessageOutput;
import ml.karmaconfigs.remote.messaging.util.message.type.MergeType;

public final class SSLRemoteServer
extends RemoteServer {
    private final String MAC;
    private final InetAddress host;
    private final int port;
    private final Socket clientSocket;

    public SSLRemoteServer(String m, InetAddress address, int incoming_port, Socket client) {
        this.MAC = m;
        this.host = address;
        this.port = incoming_port;
        this.clientSocket = client;
    }

    @Override
    public InetAddress getHost() {
        return this.host;
    }

    @Override
    public String getMAC() {
        return this.MAC;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean sendMessage(byte[] message) {
        try {
            MessageDataOutput output = new MessageDataOutput(message, MergeType.DIFFERENCE);
            ((MessageOutput)output).write("MAC", this.getMAC());
            ((MessageOutput)output).write("COMMAND_ENABLED", false);
            byte[] compile = ((MessageOutput)output).compile();
            this.clientSocket.getOutputStream().write(compile);
            this.clientSocket.getOutputStream().flush();
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

