/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.assembler;

import io.github.toolfactory.jvm.Driver;
import io.github.toolfactory.jvm.Info;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import org.burningwave.core.Cache;
import org.burningwave.core.Component;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.Objects;
import org.burningwave.core.Strings;
import org.burningwave.core.SystemProperties;
import org.burningwave.core.assembler.ComponentContainer;
import org.burningwave.core.classes.Classes;
import org.burningwave.core.classes.Constructors;
import org.burningwave.core.classes.Fields;
import org.burningwave.core.classes.Members;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.classes.Methods;
import org.burningwave.core.classes.Modules;
import org.burningwave.core.classes.PropertyAccessor;
import org.burningwave.core.classes.SourceCodeHandler;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.concurrent.Synchronizer;
import org.burningwave.core.concurrent.TasksMonitorer;
import org.burningwave.core.concurrent.Thread;
import org.burningwave.core.function.Executor;
import org.burningwave.core.function.ThrowingRunnable;
import org.burningwave.core.io.FileSystemHelper;
import org.burningwave.core.io.Resources;
import org.burningwave.core.io.Streams;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.iterable.IterableObjectHelperImpl;
import org.burningwave.core.iterable.Properties;
import org.burningwave.core.jvm.BufferHandler;

public class StaticComponentContainer {
    private static final Properties.Listener GlobalPropertiesListener;
    public static final QueuedTaskExecutor.Group BackgroundExecutor;
    public static final BufferHandler BufferHandler;
    public static final PropertyAccessor ByFieldOrByMethodPropertyAccessor;
    public static final PropertyAccessor ByMethodOrByFieldPropertyAccessor;
    public static final Cache Cache;
    public static final Classes Classes;
    public static final Classes.Loaders ClassLoaders;
    public static final Driver Driver;
    public static final Constructors Constructors;
    public static final FileSystemHelper FileSystemHelper;
    public static final Fields Fields;
    public static final org.burningwave.core.iterable.Properties GlobalProperties;
    public static final IterableObjectHelper IterableObjectHelper;
    public static final Info JVMInfo;
    public static final ManagedLogger.Repository ManagedLoggerRepository;
    public static final Members Members;
    public static final Methods Methods;
    public static final Modules Modules;
    public static final Objects Objects;
    public static final Strings.Paths Paths;
    public static final Resources Resources;
    public static final SourceCodeHandler SourceCodeHandler;
    public static final Streams Streams;
    public static final Strings Strings;
    public static final Synchronizer Synchronizer;
    public static final SystemProperties SystemProperties;
    public static final Thread.Holder ThreadHolder;
    public static final Thread.Supplier ThreadSupplier;

    private static IterableObjectHelper.ResolveConfig.ForNamedKey onGlobalPropertiesforNamedKey(String key) {
        return (IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(key).on(GlobalProperties);
    }

    private static void adjustConfigurationValues(org.burningwave.core.iterable.Properties properties) {
        String defaultValuesSeparator = (String)IterableObjectHelper.Configuration.DEFAULT_VALUES.get("iterable-object-helper.default-values-separator");
        IterableObjectHelper temporaryPropertyResolver = org.burningwave.core.iterable.IterableObjectHelper.create(properties);
        ((IterableObjectHelperImpl)temporaryPropertyResolver).checkAndUnregister(properties);
        String propertyValue = properties.getProperty("iterable-object-helper.parallel-iteration.applicability.output-collection-enabled-types");
        propertyValue = propertyValue.replace(defaultValuesSeparator, temporaryPropertyResolver.getDefaultValuesSeparator());
        properties.put("iterable-object-helper.parallel-iteration.applicability.output-collection-enabled-types", propertyValue);
        propertyValue = properties.getProperty("managed-logger.repository.logging.warn.disabled-for");
        propertyValue = propertyValue.replace(defaultValuesSeparator, temporaryPropertyResolver.getDefaultValuesSeparator());
        properties.put("managed-logger.repository.logging.warn.disabled-for", propertyValue);
    }

    private static Map<String, Object> getAndAdjustConfigurationForBackgroundExecutor() {
        if (IterableObjectHelper.resolveStringValues((IterableObjectHelper.ResolveConfig.ForAllKeysThat)IterableObjectHelper.ResolveConfig.forAllKeysThat(key -> key.matches("background-executor.queued-task-executor\\[\\d\\]\\.priority")).on(GlobalProperties)).isEmpty()) {
            GlobalProperties.put("background-executor.queued-task-executor[0].priority", (Object)1);
            if (GlobalProperties.get("background-executor.queued-task-executor[0].name") == null) {
                GlobalProperties.put("background-executor.queued-task-executor[0].name", "Low priority tasks");
            }
            GlobalProperties.put("background-executor.queued-task-executor[1].priority", (Object)5);
            if (GlobalProperties.get("background-executor.queued-task-executor[1].name") == null) {
                GlobalProperties.put("background-executor.queued-task-executor[1].name", "Normal priority tasks");
            }
            GlobalProperties.put("background-executor.queued-task-executor[2].priority", (Object)10);
            if (GlobalProperties.get("background-executor.queued-task-executor[2].name") == null) {
                GlobalProperties.put("background-executor.queued-task-executor[2].name", "High priority tasks");
            }
        }
        Map<String, Object> configuration = IterableObjectHelper.resolveValues((IterableObjectHelper.ResolveConfig.ForAllKeysThat)IterableObjectHelper.ResolveConfig.forAllKeysThat(key -> key.startsWith("background-executor.")).on(GlobalProperties));
        configuration.put("background-executor.thread-supplier", ThreadSupplier);
        configuration.put("background-executor.name", StaticComponentContainer.getName("BackgroundExecutor"));
        configuration.put("background-executor.daemon", true);
        configuration.put("background-executor.undestroyable-from-external", true);
        Map unvalidEntries = IterableObjectHelper.resolveValues((IterableObjectHelper.ResolveConfig.ForAllKeysThat)IterableObjectHelper.ResolveConfig.forAllKeysThat(key -> key.endsWith("].daemon")).on(GlobalProperties));
        Iterator unvalidEntriesItr = unvalidEntries.entrySet().iterator();
        while (unvalidEntriesItr.hasNext()) {
            String key2 = (String)unvalidEntriesItr.next().getKey();
            configuration.remove(key2);
            GlobalProperties.remove(key2);
        }
        return configuration;
    }

    private static Properties loadPropertiesFromFile(String fileName) throws IOException, ParseException {
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        classLoaders.add(StaticComponentContainer.class.getClassLoader());
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        return io.github.toolfactory.jvm.util.Properties.loadFromResourcesAndMerge(fileName, "priority-of-this-configuration-file", classLoaders.toArray(new ClassLoader[classLoaders.size()]));
    }

    private static String getName(String simpleName) {
        return Optional.ofNullable(IterableObjectHelper.resolveStringValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("group-name-for-named-elements"))).map(nm -> nm + " - ").orElseGet(() -> "") + simpleName;
    }

    private static final TasksMonitorer.Config retrieveAllTasksMonitoringConfig() {
        String probablyDeadLockedThreadsHandlingPolicy = IterableObjectHelper.resolveStringValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("background-executor.all-tasks-monitoring.probable-dead-locked-tasks-handling.policy"));
        return new TasksMonitorer.Config().setAllTasksLoggerEnabled(Objects.toBoolean(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("background-executor.all-tasks-monitoring.logger.enabled")))).setInterval(Objects.toLong(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("background-executor.all-tasks-monitoring.interval")))).setMinimumElapsedTimeToConsiderATaskAsProbablyDeadLocked(Objects.toLong(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("background-executor.all-tasks-monitoring.minimum-elapsed-time-to-consider-a-task-as-probable-dead-locked")))).setMarkAsProbableDeadLocked(probablyDeadLockedThreadsHandlingPolicy).setTerminateProbableDeadLockedTasksOperation(probablyDeadLockedThreadsHandlingPolicy);
    }

    private static void showBanner() throws IOException {
        try (InputStream inputStream = Resources.getAsInputStream((String)IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("banner.file")), Component.class.getClassLoader(), Thread.currentThread().getContextClassLoader()).getValue();){
            List<String> bannerList = Arrays.asList(Resources.getAsStringBuffer(inputStream).toString().split("-------------------------------------------------------------------------------------------------------------"));
            Collections.shuffle(bannerList);
            System.out.println("\n" + bannerList.get(new Random().nextInt(bannerList.size())));
        }
    }

    static {
        try {
            long startTime = System.nanoTime();
            SystemProperties = org.burningwave.core.SystemProperties.getInstance();
            JVMInfo = Info.Provider.getInfoInstance();
            Strings = org.burningwave.core.Strings.create();
            Objects = org.burningwave.core.Objects.create();
            Resources = new Resources();
            org.burningwave.core.iterable.Properties properties = new org.burningwave.core.iterable.Properties();
            properties.putAll(BufferHandler.Configuration.DEFAULT_VALUES);
            properties.putAll(IterableObjectHelper.Configuration.DEFAULT_VALUES);
            properties.putAll(ManagedLogger.Repository.Configuration.DEFAULT_VALUES);
            properties.putAll(Thread.Supplier.Configuration.DEFAULT_VALUES);
            properties.putAll(Configuration.DEFAULT_VALUES);
            String configFileName = Configuration.Value.FILE_NAME;
            Properties propertiesFromConfigurationFile = StaticComponentContainer.loadPropertiesFromFile(configFileName);
            properties.putAll(propertiesFromConfigurationFile);
            StaticComponentContainer.adjustConfigurationValues(properties);
            GlobalProperties = properties;
            GlobalPropertiesListener = new Properties.Listener(){

                @Override
                public <K, V> void processChangeNotification(org.burningwave.core.iterable.Properties config, Properties.Event event, K key, V newValue, V previousValue) {
                    if (key instanceof String) {
                        String keyAsString = (String)key;
                        if (event.name().equals(Properties.Event.PUT.name())) {
                            if (keyAsString.startsWith("thread-supplier.")) {
                                boolean calledByThreadSupplier = false;
                                boolean mustThrowException = true;
                                for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                                    if (stackTraceElement.getClassName().equals(Thread.Supplier.class.getName())) {
                                        calledByThreadSupplier = true;
                                        if (!stackTraceElement.getMethodName().equals("<init>")) continue;
                                        mustThrowException = false;
                                        continue;
                                    }
                                    if (calledByThreadSupplier) break;
                                }
                                if (mustThrowException) {
                                    Driver.throwException("The reconfiguration of property '{}' is not allowed", key);
                                }
                            } else if (keyAsString.equals("managed-logger.repository")) {
                                ManagedLogger.Repository toBeReplaced = ManagedLoggerRepository;
                                Fields.setStaticDirect(StaticComponentContainer.class, "ManagedLoggerRepository", ManagedLogger.Repository.create(config));
                                toBeReplaced.close();
                            } else if (keyAsString.startsWith("background-executor.all-tasks-monitoring.enabled".substring(0, "background-executor.all-tasks-monitoring.enabled".lastIndexOf(".")))) {
                                if (keyAsString.equals("background-executor.all-tasks-monitoring.enabled")) {
                                    if (!Objects.toBoolean(config.resolveValue("background-executor.all-tasks-monitoring.enabled"))) {
                                        BackgroundExecutor.stopAllTasksMonitoring();
                                    }
                                } else {
                                    BackgroundExecutor.startAllTasksMonitoring(StaticComponentContainer.retrieveAllTasksMonitoringConfig());
                                }
                            } else if (keyAsString.equals("background-executor.task-creation-tracking.enabled")) {
                                BackgroundExecutor.setTasksCreationTrackingFlag(Objects.toBoolean(config.resolveValue("background-executor.task-creation-tracking.enabled")));
                            } else if (keyAsString.equals("synchronizer.all-threads-monitoring.enabled")) {
                                if (Objects.toBoolean(config.resolveValue("synchronizer.all-threads-monitoring.enabled"))) {
                                    Synchronizer.startAllThreadsMonitoring(Objects.toLong(config.resolveValue("synchronizer.all-threads-monitoring.interval")));
                                } else {
                                    Synchronizer.stopAllThreadsMonitoring();
                                }
                            } else if (keyAsString.equals("synchronizer.all-threads-monitoring.interval")) {
                                Synchronizer.startAllThreadsMonitoring(Objects.toLong(config.resolveValue("synchronizer.all-threads-monitoring.interval")));
                            }
                        }
                    }
                }
            }.checkAndListenTo(GlobalProperties);
            IterableObjectHelper = org.burningwave.core.iterable.IterableObjectHelper.create(GlobalProperties);
            String driverClassName = (String)IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("jvm.driver.type"));
            if (driverClassName != null) {
                Driver = Executor.get(() -> (Driver)StaticComponentContainer.class.getClassLoader().loadClass(driverClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                if (Objects.toBoolean(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("jvm.driver.init")))) {
                    Driver.init();
                }
            } else {
                Driver = Objects.toBoolean(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("jvm.driver.init"))) ? Driver.Factory.getNew() : Driver.Factory.getNewDynamic();
            }
            ThreadSupplier = Thread.Supplier.create(StaticComponentContainer.getName("ThreadSupplier"), GlobalProperties, true);
            ThreadHolder = Thread.Holder.create(ThreadSupplier, true);
            BackgroundExecutor = QueuedTaskExecutor.Group.create("background-executor", StaticComponentContainer.getAndAdjustConfigurationForBackgroundExecutor());
            Synchronizer = org.burningwave.core.concurrent.Synchronizer.create(Optional.ofNullable(IterableObjectHelper.resolveStringValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("group-name-for-named-elements"))).map(nm -> nm + " - ").orElseGet(() -> "") + "Synchronizer", true);
            if (Objects.toBoolean(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("background-executor.task-creation-tracking.enabled")))) {
                BackgroundExecutor.setTasksCreationTrackingFlag(true);
            }
            if (!Objects.toBoolean(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("banner.hide")))) {
                StaticComponentContainer.showBanner();
            }
            ManagedLoggerRepository = ManagedLogger.Repository.create(GlobalProperties);
            if (propertiesFromConfigurationFile.isEmpty()) {
                ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "No custom properties found for file {}", configFileName);
            }
            ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "Instantiated {}", ManagedLoggerRepository.getClass().getName());
            ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "\n\n\tConfiguration values for static components:\n\n{}\n\n", GlobalProperties.toPrettyString(2));
            Paths = Strings.Paths.create();
            FileSystemHelper = org.burningwave.core.io.FileSystemHelper.create(StaticComponentContainer.getName("FileSystemHelper"));
            BufferHandler = org.burningwave.core.jvm.BufferHandler.create(GlobalProperties);
            Streams = org.burningwave.core.io.Streams.create();
            Classes = org.burningwave.core.classes.Classes.create();
            Cache = org.burningwave.core.Cache.create();
            Members = org.burningwave.core.classes.Members.create();
            Fields = org.burningwave.core.classes.Fields.create();
            Constructors = org.burningwave.core.classes.Constructors.create();
            Methods = org.burningwave.core.classes.Methods.create();
            ClassLoaders = Classes.Loaders.create();
            ByFieldOrByMethodPropertyAccessor = PropertyAccessor.ByFieldOrByMethod.create();
            ByMethodOrByFieldPropertyAccessor = PropertyAccessor.ByMethodOrByField.create();
            SourceCodeHandler = org.burningwave.core.classes.SourceCodeHandler.create();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                ThrowingRunnable closingOperations = () -> Executor.runAndIgnoreExceptions(() -> {
                    ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "... Waiting for all tasks ending");
                    BackgroundExecutor.waitForTasksEnding(true, true);
                });
                closingOperations = closingOperations.andThen(() -> Executor.runAndIgnoreExceptions(() -> {
                    ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "Closing all component containers");
                    ComponentContainer.closeAll();
                }));
                closingOperations = closingOperations.andThen(() -> Executor.runAndIgnoreExceptions(() -> {
                    ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "Closing FileSystemHelper");
                    FileSystemHelper.close();
                }));
                closingOperations = closingOperations.andThen(() -> Executor.runAndIgnoreExceptions(() -> {
                    ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "... Waiting for all tasks ending before shutting down the BackgroundExecutor");
                    BackgroundExecutor.waitForTasksEnding(true, true);
                })).andThen(() -> Executor.runAndIgnoreExceptions(() -> {
                    ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "Shutting down BackgroundExecutor");
                    BackgroundExecutor.shutDown(false);
                })).andThen(() -> Executor.runAndIgnoreExceptions(() -> {
                    ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "Stopping all threads monitoring thread");
                    Synchronizer.stopAllThreadsMonitoring(false);
                })).andThen(() -> Executor.runAndIgnoreExceptions(() -> {
                    ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "Closing ThreadHolder");
                    ThreadHolder.close();
                })).andThen(() -> Executor.runAndIgnoreExceptions(() -> {
                    ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "Shutting down ThreadSupplier");
                    ThreadSupplier.shutDownAllThreads();
                })).andThen(() -> Executor.runAndIgnoreExceptions(() -> MemoryClassLoader.DebugSupport.logAllInstancesInfo()));
                Executor.runAndIgnoreExceptions(closingOperations);
            }, StaticComponentContainer.getName("Resource releaser")));
            ManagedLoggerRepository.logInfo(StaticComponentContainer.class::getName, "{} initialized in {} seconds", StaticComponentContainer.class.getName(), Double.valueOf((double)(System.nanoTime() - startTime) / 1.0E9).toString());
            if (Objects.toBoolean(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("synchronizer.all-threads-monitoring.enabled")))) {
                Synchronizer.startAllThreadsMonitoring(Objects.toLong(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("synchronizer.all-threads-monitoring.interval"))));
            }
            if (Objects.toBoolean(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("background-executor.all-tasks-monitoring.enabled")))) {
                BackgroundExecutor.startAllTasksMonitoring(StaticComponentContainer.retrieveAllTasksMonitoringConfig());
            }
            if (JVMInfo.getVersion() > 8) {
                Modules = org.burningwave.core.classes.Modules.create();
                if (Objects.toBoolean(IterableObjectHelper.resolveValue(StaticComponentContainer.onGlobalPropertiesforNamedKey("modules.export-all-to-all")))) {
                    try {
                        Modules.exportAllToAll();
                    }
                    catch (Throwable exc) {
                        ManagedLoggerRepository.logError(StaticComponentContainer.class::getName, "Unable to export all modules to all modules", exc);
                    }
                }
            } else {
                Modules = null;
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            throw new RuntimeException(exc);
        }
    }

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues.put("group-name-for-named-elements", "Burningwave");
            defaultValues.put("banner.hide", false);
            defaultValues.put("banner.file", "org/burningwave/banner.bwb");
            defaultValues.put("synchronizer.all-threads-monitoring.enabled", false);
            defaultValues.put("synchronizer.all-threads-monitoring.interval", 90000);
            defaultValues.put("background-executor.all-tasks-monitoring.enabled", true);
            defaultValues.put("background-executor.all-tasks-monitoring.minimum-elapsed-time-to-consider-a-task-as-probable-dead-locked", 300000);
            defaultValues.put("background-executor.all-tasks-monitoring.interval", 30000);
            defaultValues.put("background-executor.all-tasks-monitoring.probable-dead-locked-tasks-handling.policy", "log only");
            defaultValues.put("background-executor.task-creation-tracking.enabled", "${background-executor.all-tasks-monitoring.enabled}");
            defaultValues.put("background-executor.all-tasks-monitoring.logger.enabled", false);
            if (Info.Provider.getInfoInstance().getVersion() > 8) {
                defaultValues.put("modules.export-all-to-all", true);
            }
            defaultValues.put("jvm.driver.init", false);
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            private static final String GROUP_NAME_FOR_NAMED_ELEMENTS = "group-name-for-named-elements";
            private static final String BANNER_HIDE = "banner.hide";
            private static final String BANNER_FILE = "banner.file";
            private static final String BACKGROUND_EXECUTOR_TASK_CREATION_TRACKING_ENABLED = "background-executor.task-creation-tracking.enabled";
            private static final String BACKGROUND_EXECUTOR_ALL_TASKS_MONITORING_ENABLED = "background-executor.all-tasks-monitoring.enabled";
            private static final String BACKGROUND_EXECUTOR_ALL_TASKS_MONITORING_MINIMUM_ELAPSED_TIME_TO_CONSIDER_A_TASK_AS_PROBABLE_DEAD_LOCKED = "background-executor.all-tasks-monitoring.minimum-elapsed-time-to-consider-a-task-as-probable-dead-locked";
            private static final String BACKGROUND_EXECUTOR_ALL_TASKS_MONITORING_LOGGER_ENABLED = "background-executor.all-tasks-monitoring.logger.enabled";
            private static final String BACKGROUND_EXECUTOR_ALL_TASKS_MONITORING_INTERVAL = "background-executor.all-tasks-monitoring.interval";
            private static final String BACKGROUND_EXECUTOR_ALL_TASKS_MONITORING_PROBABLE_DEAD_LOCKED_TASKS_HANDLING_POLICY = "background-executor.all-tasks-monitoring.probable-dead-locked-tasks-handling.policy";
            private static final String JVM_DRIVER_TYPE = "jvm.driver.type";
            private static final String JVM_DRIVER_INIT = "jvm.driver.init";
            private static final String MODULES_EXPORT_ALL_TO_ALL = "modules.export-all-to-all";
            private static final String SYNCHRONIZER_ALL_THREADS_MONITORING_ENABLED = "synchronizer.all-threads-monitoring.enabled";
            private static final String SYNCHRONIZER_ALL_THREADS_MONITORING_INTERVAL = "synchronizer.all-threads-monitoring.interval";
        }

        public static class Value {
            public static String FILE_NAME = "burningwave.static.properties";
        }
    }
}

