/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class HtmlEmbed
extends HtmlElement {
    public static final String TAG_NAME = "embed";

    HtmlEmbed(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public void saveAs(File file) throws IOException {
        HtmlPage page = (HtmlPage)this.getPage();
        WebClient webclient = page.getWebClient();
        URL url = page.getFullyQualifiedUrl(this.getAttributeDirect("src"));
        WebRequest request = new WebRequest(url);
        request.setCharset(page.getCharset());
        request.setRefererlHeader(page.getUrl());
        WebResponse webResponse = webclient.loadWebResponse(request);
        try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);
             InputStream content = webResponse.getContentAsStream();){
            IOUtils.copy(content, fos);
        }
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }
}

