/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebConsole;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.BaseFunction;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Delegator;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.JavaScriptException;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.NativeFunction;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClasses(value={@JsxClass(isJSObject=false, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR}), @JsxClass(value={SupportedBrowser.IE})})
public class Console
extends HtmlUnitScriptable {
    private static final Map<String, Long> TIMERS = new HashMap<String, Long>();
    private static final WebConsole.Formatter FORMATTER_ = new ConsoleFormatter();
    private WebWindow webWindow_;

    public void setWebWindow(WebWindow webWindow) {
        this.webWindow_ = webWindow;
    }

    @JsxFunction(functionName="assert")
    public static void assertMethod(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object[] data;
        if (args.length < 1 || ScriptRuntime.toBoolean(args[0])) {
            return;
        }
        if (args.length == 1) {
            Console.log(cx, thisObj, new String[]{"Assertion failed"}, null);
            return;
        }
        Object first = args[1];
        if (first instanceof CharSequence || first instanceof ScriptableObject && "String".equals(((Scriptable)first).getClassName())) {
            data = new Object[args.length - 1];
            data[0] = "Assertion failed: " + first;
            System.arraycopy(args, 2, data, 1, data.length - 1);
        } else {
            data = new Object[args.length];
            data[0] = "Assertion failed:";
            System.arraycopy(args, 1, data, 1, data.length - 1);
        }
        Console.log(cx, thisObj, data, null);
    }

    @JsxFunction
    public static void log(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        WebConsole webConsole = Console.toWebConsole(thisObj);
        WebConsole.Formatter oldFormatter = webConsole.getFormatter();
        webConsole.setFormatter(FORMATTER_);
        webConsole.info(args);
        webConsole.setFormatter(oldFormatter);
    }

    private static WebConsole toWebConsole(Scriptable thisObj) {
        if (thisObj instanceof Window && ((HtmlUnitScriptable)thisObj).getDomNodeOrDie().hasFeature(BrowserVersionFeatures.JS_CONSOLE_HANDLE_WINDOW)) {
            thisObj = ((Window)thisObj).getConsole();
        }
        if (thisObj instanceof Console) {
            return ((Console)thisObj).getWebConsole();
        }
        throw ScriptRuntime.typeError("object does not implemennt interface Console");
    }

    @JsxFunction
    public static void info(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        WebConsole webConsole = Console.toWebConsole(thisObj);
        WebConsole.Formatter oldFormatter = webConsole.getFormatter();
        webConsole.setFormatter(FORMATTER_);
        webConsole.info(args);
        webConsole.setFormatter(oldFormatter);
    }

    @JsxFunction
    public static void warn(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        WebConsole webConsole = Console.toWebConsole(thisObj);
        WebConsole.Formatter oldFormatter = webConsole.getFormatter();
        webConsole.setFormatter(FORMATTER_);
        webConsole.warn(args);
        webConsole.setFormatter(oldFormatter);
    }

    @JsxFunction
    public static void error(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        WebConsole webConsole = Console.toWebConsole(thisObj);
        WebConsole.Formatter oldFormatter = webConsole.getFormatter();
        webConsole.setFormatter(FORMATTER_);
        webConsole.error(args);
        webConsole.setFormatter(oldFormatter);
    }

    @JsxFunction
    public static void debug(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        WebConsole webConsole = Console.toWebConsole(thisObj);
        WebConsole.Formatter oldFormatter = webConsole.getFormatter();
        webConsole.setFormatter(FORMATTER_);
        webConsole.debug(args);
        webConsole.setFormatter(oldFormatter);
    }

    @JsxFunction
    public static void trace(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JavaScriptException e = ScriptRuntime.throwError(cx, funObj, null);
        WebConsole webConsole = Console.toWebConsole(thisObj);
        WebConsole.Formatter oldFormatter = webConsole.getFormatter();
        webConsole.setFormatter(FORMATTER_);
        webConsole.info(e.getScriptStackTrace());
        webConsole.setFormatter(oldFormatter);
    }

    private WebConsole getWebConsole() {
        Scriptable s;
        if (this.webWindow_ == null && (s = Console.getTopLevelScope(this)) instanceof Window) {
            return ((Window)s).getWebWindow().getWebClient().getWebConsole();
        }
        return this.webWindow_.getWebClient().getWebConsole();
    }

    @JsxFunction
    public void dir(Object o) {
        ScriptableObject obj;
        Object[] ids;
        if (o instanceof ScriptableObject && (ids = (obj = (ScriptableObject)o).getIds()) != null && ids.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (Object id : ids) {
                Object value = obj.get(id);
                if (value instanceof Delegator) {
                    sb.append(id).append(": ").append(((Delegator)value).getClassName()).append('\n');
                    continue;
                }
                if (value instanceof HtmlUnitScriptable) {
                    sb.append(id).append(": ").append(((HtmlUnitScriptable)value).getClassName()).append('\n');
                    continue;
                }
                if (value instanceof BaseFunction) {
                    sb.append(id).append(": function ").append(((BaseFunction)value).getFunctionName()).append("()\n");
                    continue;
                }
                sb.append(id).append(": ").append(value).append('\n');
            }
            this.getWebConsole().info(sb.toString());
        }
    }

    @JsxFunction
    public void group() {
    }

    @JsxFunction
    public void groupEnd() {
    }

    @JsxFunction
    public void groupCollapsed() {
    }

    @JsxFunction
    public void time(String timerName) {
        if (!TIMERS.containsKey(timerName)) {
            TIMERS.put(timerName, System.currentTimeMillis());
        }
        this.getWebConsole().info(timerName + ": timer started");
    }

    @JsxFunction
    public void timeEnd(String timerName) {
        Long startTime = TIMERS.remove(timerName);
        if (startTime != null) {
            this.getWebConsole().info(timerName + ": " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void timeStamp(String label) {
    }

    private static class ConsoleFormatter
    implements WebConsole.Formatter {
        private static void appendNativeArray(NativeArray a, StringBuilder sb, int level) {
            sb.append('[');
            if (level < 3) {
                for (int i = 0; i < a.size(); ++i) {
                    Object val;
                    if (i > 0) {
                        sb.append(", ");
                    }
                    if ((val = a.get(i)) == null) continue;
                    ConsoleFormatter.appendValue(val, sb, level + 1);
                }
            }
            sb.append(']');
        }

        private static void appendNativeObject(NativeObject obj, StringBuilder sb, int level) {
            Object[] ids;
            if (level == 0) {
                sb.append('(');
            }
            sb.append('{');
            if (level < 3 && (ids = obj.getIds()) != null && ids.length > 0) {
                boolean needsSeparator = false;
                for (Object key : ids) {
                    if (needsSeparator) {
                        sb.append(", ");
                    }
                    sb.append(key);
                    sb.append(": ");
                    ConsoleFormatter.appendValue(obj.get(key), sb, level + 1);
                    needsSeparator = true;
                }
            }
            sb.append('}');
            if (level == 0) {
                sb.append(')');
            }
        }

        private static void appendValue(Object val, StringBuilder sb, int level) {
            if (val instanceof NativeFunction) {
                sb.append('(');
                Pattern p = Pattern.compile("[ \\t]*\\r?\\n[ \\t]*", 8);
                Matcher m = p.matcher(val.toString());
                sb.append(m.replaceAll(" ").trim());
                sb.append(')');
            } else if (val instanceof BaseFunction) {
                sb.append("function ");
                sb.append(((BaseFunction)val).getFunctionName());
                sb.append("() {[native code]}");
            } else if (val instanceof NativeObject) {
                ConsoleFormatter.appendNativeObject((NativeObject)val, sb, level);
            } else if (val instanceof NativeArray) {
                ConsoleFormatter.appendNativeArray((NativeArray)val, sb, level);
            } else if (val instanceof Delegator) {
                if (level == 0) {
                    sb.append("[object ");
                    sb.append(((Delegator)val).getDelegee().getClassName());
                    sb.append(']');
                } else {
                    sb.append("({})");
                }
            } else if (val instanceof HtmlUnitScriptable) {
                if (level == 0) {
                    sb.append("[object ");
                    sb.append(((HtmlUnitScriptable)val).getClassName());
                    sb.append(']');
                } else {
                    sb.append("({})");
                }
            } else if (val instanceof String) {
                if (level == 0) {
                    sb.append((String)val);
                } else {
                    sb.append(ConsoleFormatter.quote((String)val));
                }
            } else if (val instanceof Number) {
                sb.append(val.toString());
            } else {
                sb.append(val);
            }
        }

        private static String quote(CharSequence s) {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            block9: for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\\': {
                        sb.append("\\\\");
                        continue block9;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block9;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block9;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block9;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block9;
                    }
                    default: {
                        if (ch < ' ' || ch > '~') {
                            sb.append("\\u").append(Integer.toHexString(ch).toUpperCase(Locale.ROOT));
                            continue block9;
                        }
                        sb.append(ch);
                    }
                }
            }
            sb.append('\"');
            return sb.toString();
        }

        private static String formatToString(Object o) {
            if (o == null) {
                return "null";
            }
            if (o instanceof NativeFunction) {
                return o.toString();
            }
            if (o instanceof BaseFunction) {
                return "function " + ((BaseFunction)o).getFunctionName() + "\n    [native code]\n}";
            }
            if (o instanceof NativeArray) {
                return "[object Object]";
            }
            if (o instanceof Delegator) {
                return "[object " + ((Delegator)o).getDelegee().getClassName() + "]";
            }
            if (o instanceof NativeObject) {
                return "[object " + ((NativeObject)o).getClassName() + "]";
            }
            if (o instanceof HtmlUnitScriptable) {
                return "[object " + ((HtmlUnitScriptable)o).getClassName() + "]";
            }
            return o.toString();
        }

        ConsoleFormatter() {
        }

        @Override
        public String printObject(Object o) {
            StringBuilder sb = new StringBuilder();
            ConsoleFormatter.appendValue(o, sb, 0);
            return sb.toString();
        }

        @Override
        public String parameterAsString(Object o) {
            if (o instanceof NativeArray) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < ((NativeArray)o).size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(ConsoleFormatter.formatToString(((NativeArray)o).get(i)));
                }
                return sb.toString();
            }
            return ConsoleFormatter.formatToString(o);
        }

        @Override
        public String parameterAsInteger(Object o) {
            if (o instanceof Number) {
                return Integer.toString(((Number)o).intValue());
            }
            if (o instanceof String) {
                try {
                    return Integer.toString(Integer.parseInt((String)o));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return "NaN";
        }

        @Override
        public String parameterAsFloat(Object o) {
            if (o instanceof Number) {
                return Float.toString(((Number)o).floatValue());
            }
            if (o instanceof String) {
                try {
                    return Float.toString(Float.parseFloat((String)o));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return "NaN";
        }
    }
}

