/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HTMLCollectionFrames
extends HTMLCollection {
    private static final Log LOG = LogFactory.getLog(HTMLCollectionFrames.class);

    HTMLCollectionFrames(HtmlPage page) {
        super((DomNode)page, false);
    }

    @Override
    protected boolean isMatching(DomNode node) {
        return node instanceof BaseFrameElement;
    }

    @Override
    protected Scriptable getScriptableForElement(Object obj) {
        FrameWindow window = obj instanceof BaseFrameElement ? ((BaseFrameElement)obj).getEnclosedWindow() : ((FrameWindow)obj).getFrameElement().getEnclosedWindow();
        return (Scriptable)window.getScriptableObject();
    }

    @Override
    protected Object getWithPreemption(String name) {
        List<DomNode> elements = this.getElements();
        for (DomNode next : elements) {
            BaseFrameElement frameElt = (BaseFrameElement)next;
            FrameWindow window = frameElt.getEnclosedWindow();
            if (name.equals(window.getName())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Property \"" + name + "\" evaluated (by name) to " + window);
                }
                return this.getScriptableForElement(window);
            }
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_FRAMES_ACCESSIBLE_BY_ID) || !frameElt.getId().equals(name)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Property \"" + name + "\" evaluated (by id) to " + window);
            }
            return this.getScriptableForElement(window);
        }
        return NOT_FOUND;
    }
}

